/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.entities.SpectatorVision;
import net.orcinus.galosphere.entities.ThrowableLaunchedProjectile;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import org.jetbrains.annotations.Nullable;

public class SpectreFlare
extends ThrowableLaunchedProjectile {
    public SpectreFlare(EntityType<? extends SpectreFlare> type, Level world) {
        super(type, world);
    }

    public SpectreFlare(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        super(world, stack, entity, x, y, z, shotAtAngle);
    }

    public SpectreFlare(Level level, @Nullable Entity entity, ItemStack itemStack) {
        super(GEntityTypes.SPECTRE_FLARE.get(), level);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, (Object)itemStack.copy());
        this.entityData.set(THROWN, (Object)true);
        this.setOwner(entity);
    }

    @Override
    public void handleLaunchedProjectile() {
        Level world = this.level();
        if (!world.isClientSide && this.life > this.lifetime) {
            this.spawnSpectatorVision(this.position());
            world.broadcastEntityEvent((Entity)this, (byte)17);
            this.gameEvent((Holder)GameEvent.EXPLODE, this.getOwner());
            this.discard();
        }
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)GItems.SPECTRE_FLARE.get();
    }

    protected void onHitBlock(BlockHitResult result) {
        Level world = this.level();
        if (!world.isClientSide()) {
            BlockPos hitPos = result.getBlockPos();
            BlockPos placePos = hitPos.relative(result.getDirection());
            if (world.getBlockState(hitPos).isCollisionShapeFullBlock((BlockGetter)world, hitPos) && (world.getFluidState(placePos).is(FluidTags.LAVA) || world.isStateAtPosition(placePos, DripstoneUtils::isEmptyOrWater))) {
                this.spawnSpectatorVision(Vec3.atCenterOf((Vec3i)placePos));
            } else {
                this.spawnAtLocation((ServerLevel)world, this.getItem());
            }
            this.discard();
        }
    }

    private void spawnSpectatorVision(Vec3 vec3) {
        ServerPlayer serverPlayer;
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer && !((Boolean)(serverPlayer = (ServerPlayer)entity).getData(GAttachmentTypes.IS_SPECTRE_BOUNDED)).booleanValue()) {
            SpectatorVision spectatorVision = SpectatorVision.create(this.level(), vec3, serverPlayer, 120);
            serverPlayer.playNotifySound(GSoundEvents.SPECTRE_MANIPULATE_BEGIN.get(), this.getSoundSource(), 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)spectatorVision);
            serverPlayer.setData(GAttachmentTypes.IS_SPECTRE_BOUNDED, (Object)true);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SendPerspectivePacket(serverPlayer.getUUID(), spectatorVision.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)GItems.SPECTRE_FLARE.get());
    }
}

