/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.entities.ai.tasks.mole.AssignBurrow;
import net.orcinus.galosphere.entities.ai.tasks.mole.CreateBurrow;
import net.orcinus.galosphere.entities.ai.tasks.mole.DigUp;
import net.orcinus.galosphere.entities.ai.tasks.mole.FinishedRummaging;
import net.orcinus.galosphere.entities.ai.tasks.mole.MoleSearching;
import net.orcinus.galosphere.entities.ai.tasks.mole.MoleSniffing;
import net.orcinus.galosphere.entities.ai.tasks.mole.ReturnBurrow;
import net.orcinus.galosphere.entities.ai.tasks.mole.Rummaging;
import net.orcinus.galosphere.entities.ai.tasks.mole.Twitching;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import org.jetbrains.annotations.Nullable;

public class MoleAi {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final ImmutableList<SensorType<? extends Sensor<? super Mole>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_ADULT, GSensorTypes.MOLE_TEMPTATIONS.get(), GSensorTypes.NEAREST_MOLE_BURROW.get(), GSensorTypes.NEAREST_TUFF_DIRT.get(), GSensorTypes.MOLE_REPELLENTS.get(), GSensorTypes.MOLE_ENTITY_SENSOR.get());
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.SNIFF_COOLDOWN, MemoryModuleType.IS_EMERGING, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.AVOID_TARGET, GMemoryModuleTypes.MOLE_DIGGING.get(), GMemoryModuleTypes.MOLE_RETURNING.get(), GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), GMemoryModuleTypes.NEAREST_MOLE_BURROW.get(), GMemoryModuleTypes.MOLE_HOMING.get(), GMemoryModuleTypes.NEAREST_TUFF_DIRT.get()});
    public static final UniformInt AVOID_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)7);

    public static Brain.Provider<Mole> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<Mole> brain) {
        MoleAi.initCoreActivity(brain);
        MoleAi.initIdleActivity(brain);
        MoleAi.initAvoidActivity(brain);
        MoleAi.initFightActivity(brain);
        MoleAi.initEmergeActivity(brain);
        MoleAi.initSniffingActivity(brain);
        MoleAi.initDiggingActivity(brain);
        MoleAi.initBurrowCreatingActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Mole> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)((Object)new AssignBurrow()), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<Mole> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, MoleAi.avoidRepellent()), (Object)Pair.of((Object)1, (Object)StartAttacking.create((serverLevel, mole) -> mole.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)2, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new AnimalMakeLove(GEntityTypes.MOLE.get())), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f), livingEntity -> livingEntity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)1.25f), (Object)1)))), (Object)Pair.of((Object)5, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)6, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new ReturnBurrow()), (Object)1), (Object)Pair.of((Object)((Object)new Twitching()), (Object)1), (Object)Pair.of((Object)((Object)new MoleSniffing()), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), Set.of(Pair.of(GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initEmergeActivity(Brain<Mole> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.EMERGE, 5, ImmutableList.of((Object)((Object)new DigUp())), MemoryModuleType.IS_EMERGING);
    }

    private static void initSniffingActivity(Brain<Mole> brain) {
        brain.addActivityWithConditions(Activity.SNIFF, ImmutableList.of((Object)Pair.of((Object)0, MoleAi.avoidRepellent()), (Object)Pair.of((Object)1, (Object)((Object)new MoleSearching()))), Set.of(Pair.of(GMemoryModuleTypes.MOLE_HOMING.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(GMemoryModuleTypes.MOLE_RETURNING.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initDiggingActivity(Brain<Mole> brain) {
        brain.addActivityWithConditions(Activity.DIG, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Rummaging())), (Object)Pair.of((Object)1, (Object)((Object)new FinishedRummaging()))), Set.of(Pair.of(GMemoryModuleTypes.MOLE_HOMING.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(GMemoryModuleTypes.MOLE_RETURNING.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of(GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initFightActivity(Brain<Mole> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.5f), (Object)MeleeAttack.create((int)20), (Object)EraseMemoryIf.create(BehaviorUtils::isBreeding, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initBurrowCreatingActivity(Brain<Mole> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.HIDE, 5, ImmutableList.of(MoleAi.avoidRepellent(), (Object)GoToTargetLocation.create(GMemoryModuleTypes.NEAREST_TUFF_DIRT.get(), (int)1, (float)1.0f), (Object)((Object)new CreateBurrow()), (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new Twitching()), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))), GMemoryModuleTypes.MOLE_HOMING.get());
    }

    private static void initAvoidActivity(Brain<Mole> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 5, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.75f, (int)15, (boolean)false), (Object)EraseMemoryIf.create(mole -> !mole.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET), (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    public static SoundEvent getSoundForActivity(Mole mole) {
        Optional activity = mole.getBrain().getActiveNonCoreActivity();
        return activity.isPresent() && activity.get() == Activity.AVOID ? SoundEvents.FOX_SCREECH : SoundEvents.FOX_AMBIENT;
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.5f, (int)8, (boolean)false);
    }

    public static void updateActivity(Mole mole) {
        mole.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.HIDE, (Object)Activity.DIG, (Object)Activity.SNIFF, (Object)Activity.FIGHT, (Object)Activity.EMERGE, (Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return itemStack -> itemStack.is(GItemTags.MOLE_FOOD) || itemStack.is(GItemTags.MOLE_FAVORITES);
    }

    public static boolean validRepellent(ServerLevel serverLevel, @Nullable BlockPos blockPos, @Nullable LivingEntity target) {
        if (blockPos != null) {
            return serverLevel.getBlockState(blockPos).is(GBlockTags.MOLE_REPELLENTS);
        }
        if (target != null) {
            return target.getMainHandItem().is(GItemTags.MOLE_REPELLENTS) || target.getOffhandItem().is(GItemTags.MOLE_REPELLENTS);
        }
        return false;
    }
}

