/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Summon
extends Behavior<Berserker> {
    private static final int MAX_DURATION = 70;

    public Summon() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.RAMPAGE_TICKS.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.IS_SMASHING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_IMPALING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_SUMMONING.get(), (Object)MemoryStatus.REGISTERED, GMemoryModuleTypes.SUMMONING_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.SUMMON_COUNT.get(), (Object)MemoryStatus.REGISTERED), 70);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker livingEntity) {
        return livingEntity.getHealth() / livingEntity.getMaxHealth() <= 0.66f && livingEntity.hasPose(Pose.STANDING) && livingEntity.shouldAttack();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.getBrain();
        brain.setMemoryWithExpiry(GMemoryModuleTypes.IS_SUMMONING.get(), (Object)Unit.INSTANCE, 70L);
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        livingEntity.setPhase(Berserker.Phase.SUMMONING);
        livingEntity.playSound(GSoundEvents.BERSERKER_SUMMONING.get(), 10.0f, 1.0f);
    }

    protected void tick(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.getBrain();
        brain.setMemory(GMemoryModuleTypes.SUMMON_COUNT.get(), (Object)(brain.getMemory(GMemoryModuleTypes.SUMMON_COUNT.get()).orElse(0) + 1));
        List<LivingEntity> list = serverLevel.getEntitiesOfClass(LivingEntity.class, livingEntity.getBoundingBox().inflate(4.0)).stream().filter(living -> livingEntity.canTargetEntity(serverLevel, (Entity)living)).filter(e -> e.getUUID() != livingEntity.getUUID()).toList();
        float time = livingEntity.getBrain().getTimeUntilExpiry(GMemoryModuleTypes.IS_SUMMONING.get());
        if (time > 20.0f) {
            for (LivingEntity entity : list) {
                if (time % 4.0f != 0.0f) continue;
                entity.hurt(serverLevel.damageSources().mobAttack((LivingEntity)livingEntity), 2.0f);
            }
        }
        int max = UniformInt.of((int)3, (int)5).sample(serverLevel.getRandom());
        if (serverLevel.getDifficulty() == Difficulty.HARD) {
            max = UniformInt.of((int)4, (int)8).sample(serverLevel.getRandom());
        }
        if (brain.hasMemoryValue(GMemoryModuleTypes.SUMMON_COUNT.get()) && (Integer)brain.getMemory(GMemoryModuleTypes.SUMMON_COUNT.get()).get() > max) {
            return;
        }
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        List<BlockPos> positions = IntStream.range(0, 5).mapToObj(i -> LandRandomPos.getPos((PathfinderMob)livingEntity, (int)(i * 2), (int)1)).filter(Objects::nonNull).map(BlockPos::containing).filter(blockPos -> livingEntity.level().getWorldBorder().isWithinBounds(blockPos)).map(BlockPos::below).filter(blockPos -> serverLevel.getBlockState(blockPos).isCollisionShapeFullBlock((BlockGetter)serverLevel, blockPos)).toList();
        if (positions.isEmpty()) {
            return;
        }
        BlockPos randomPos = positions.get(serverLevel.getRandom().nextInt(positions.size()));
        Preserved preserved = (Preserved)GEntityTypes.PRESERVED.get().spawn(serverLevel, null, null, livingEntity.blockPosition(), EntitySpawnReason.TRIGGERED, true, true);
        preserved.moveTo(randomPos.getX(), randomPos.getY() + 1, randomPos.getZ(), 0.0f, 0.0f);
        preserved.setHealth(preserved.getMaxHealth() * ((float)livingEntity.getRandom().nextInt(4, 7) / 10.0f));
        serverLevel.addFreshEntityWithPassengers((Entity)preserved);
    }

    protected void stop(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
        livingEntity.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.SUMMONING_COOLDOWN.get(), (Object)Unit.INSTANCE, 600L);
        livingEntity.getBrain().setMemory(GMemoryModuleTypes.SUMMON_COUNT.get(), (Object)0);
    }
}

