/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Undermine
extends Behavior<Berserker> {
    private static final int DURATION = Mth.ceil((float)22.4f);
    private static final int MAX_DURATION = 50;

    public Undermine() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.RAMPAGE_TICKS.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.IMPALING_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_SMASHING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_IMPALING.get(), (Object)MemoryStatus.REGISTERED, GMemoryModuleTypes.IS_SUMMONING.get(), (Object)MemoryStatus.VALUE_ABSENT), 50);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker mob) {
        List list = serverLevel.getEntitiesOfClass(LivingEntity.class, mob.getBoundingBox());
        for (LivingEntity nearby : list) {
            if (!nearby.isAlive() || nearby.getType() == GEntityTypes.BERSERKER.get()) continue;
            return false;
        }
        return mob.hasPose(Pose.STANDING) && mob.shouldAttack() && mob.closerThan((Entity)mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get(), 15.0, 20.0);
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker mob, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker mob, long l) {
        Brain<Berserker> brain = mob.getBrain();
        brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)DURATION);
        brain.setMemoryWithExpiry(GMemoryModuleTypes.IS_IMPALING.get(), (Object)Unit.INSTANCE, 50L);
        brain.setMemory(GMemoryModuleTypes.IMPALING_COUNT.get(), (Object)(brain.getMemory(GMemoryModuleTypes.IMPALING_COUNT.get()).orElse(0) + 1));
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        mob.setPhase(Berserker.Phase.UNDERMINE);
        mob.playSound(GSoundEvents.BERSERKER_SMASH.get(), 3.0f, 1.0f);
    }

    protected void tick(ServerLevel serverLevel, Berserker mob, long l) {
        Optional memory = mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        memory.ifPresent(target -> mob.getLookControl().setLookAt(target.position()));
        mob.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        if (mob.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_COOLING_DOWN)) {
            return;
        }
        if (memory.isPresent() && mob.canTargetEntity(serverLevel, (Entity)memory.get())) {
            LivingEntity target2 = (LivingEntity)memory.get();
            double d = Math.min(target2.getY(), mob.getY());
            double e = Math.max(target2.getY(), mob.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(target2.getZ() - mob.getZ()), (double)(target2.getX() - mob.getX()));
            if (mob.distanceTo((Entity)target2) < 4.0f) {
                float g;
                int index;
                mob.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(-1.0, -1.0, -1.0));
                for (index = 0; index < 5; ++index) {
                    g = f + (float)index * (float)Math.PI * 0.4f;
                    this.createPillar(mob, 0, 4.0f, 0.0f, mob.getX() + (double)Mth.cos((float)g) * 1.5, mob.getZ() + (double)Mth.sin((float)g) * 1.5, d, e, g);
                }
                for (index = 0; index < 8; ++index) {
                    g = f + (float)index * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createPillar(mob, 3, 4.0f, 0.0f, mob.getX() + (double)Mth.cos((float)g) * 2.5, mob.getZ() + (double)Mth.sin((float)g) * 2.5, d, e, g);
                }
            } else {
                mob.lookAt(EntityAnchorArgument.Anchor.EYES, target2.position());
                for (int index = 0; index < 16; ++index) {
                    double h = 1.25 * (double)(index + 1);
                    this.createPillar(mob, index, 6.0f, 0.2f, mob.getX() + (double)Mth.cos((float)f) * h + (double)((mob.getRandom().nextFloat() - 0.5f) * 0.4f), mob.getZ() + (double)Mth.sin((float)f) * h + (double)((mob.getRandom().nextFloat() - 0.5f) * 0.4f), d, e, f);
                }
            }
        }
        mob.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)(50 - DURATION));
    }

    private void createPillar(Berserker mob, int index, float damage, float damageLowerRate, double d, double e, double f, double g, float h) {
        BlockPos blockPos = BlockPos.containing((double)d, (double)g, (double)e);
        boolean bl = false;
        double j = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos blockPos2 = blockPos.below();
            BlockState blockState = mob.level().getBlockState(blockPos2);
            if (!blockState.isFaceSturdy((BlockGetter)mob.level(), blockPos2, Direction.UP)) continue;
            if (!mob.level().isEmptyBlock(blockPos) && !(voxelShape = mob.level().getBlockState(blockPos).getCollisionShape((BlockGetter)mob.level(), blockPos)).isEmpty()) {
                j = voxelShape.max(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.below()).getY() >= Mth.floor((double)f) - 1);
        if (bl) {
            if (damageLowerRate > 0.0f) {
                damage -= (float)index * damageLowerRate;
            }
            mob.level().addFreshEntity((Entity)new PinkSaltPillar(mob.level(), d, (double)blockPos.getY() + j, e, h, index, damage, (LivingEntity)mob));
        }
    }

    protected void stop(ServerLevel serverLevel, Berserker mob, long l) {
        mob.setPhase(Berserker.Phase.IDLING);
        Optional memory = mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        Optional undermine = mob.getBrain().getMemory(GMemoryModuleTypes.IMPALING_COUNT.get());
        if (undermine.isPresent() && (Integer)undermine.get() >= 3) {
            mob.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.IMPALING_COOLDOWN.get(), (Object)Unit.INSTANCE, 50L);
            mob.getBrain().setMemory(GMemoryModuleTypes.IMPALING_COUNT.get(), (Object)0);
        } else if (memory.isPresent() && (double)((LivingEntity)memory.get()).distanceTo((Entity)mob) < 4.0) {
            mob.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.IMPALING_COOLDOWN.get(), (Object)Unit.INSTANCE, 400L);
        }
    }
}

