/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class FinishedRummaging
extends Behavior<Mole> {
    public FinishedRummaging() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.MOLE_RETURNING.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.SNIFF_COOLDOWN, (Object)MemoryStatus.VALUE_PRESENT), 40);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mole livingEntity) {
        return true;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Mole livingEntity, long l) {
        return livingEntity.getBrain().getMemory(GMemoryModuleTypes.MOLE_DIGGING.get()).isPresent();
    }

    protected void start(ServerLevel serverLevel, Mole livingEntity, long l) {
        livingEntity.transitionTo(Mole.State.EMERGE);
    }

    protected void stop(ServerLevel serverLevel, Mole livingEntity, long l) {
        livingEntity.transitionTo(Mole.State.IDLING);
        livingEntity.getBrain().eraseMemory(GMemoryModuleTypes.MOLE_DIGGING.get());
        livingEntity.getBrain().setMemory(GMemoryModuleTypes.MOLE_RETURNING.get(), (Object)true);
        Optional.ofNullable(livingEntity.getBurrowPos()).ifPresent(blockPos -> livingEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(blockPos.above(), 1.65f, 0)));
    }
}

