/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.orcinus.galosphere.api.HaliteCurse;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.config.GalosphereConfig;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.entities.RopeDartProjectile;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.SpectatorVision;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.items.SterlingArmorItem;
import net.orcinus.galosphere.items.components.SpectreBound;
import net.orcinus.galosphere.util.PreservedShulkerBox;

@EventBusSubscriber(modid="galosphere")
public class MobEvents {
    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(GEntityTypes.SPARKLE.get(), Sparkle.createAttributes().build());
        event.put(GEntityTypes.SPECTRE.get(), Spectre.createAttributes().build());
        event.put(GEntityTypes.SPECTERPILLAR.get(), Specterpillar.createAttributes().build());
        event.put(GEntityTypes.SPECTATOR_VISION.get(), SpectatorVision.createAttributes().build());
        event.put(GEntityTypes.BERSERKER.get(), Berserker.createAttributes().build());
        event.put(GEntityTypes.PRESERVED.get(), Preserved.createAttributes().build());
        event.put(GEntityTypes.MOLE.get(), Mole.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(GEntityTypes.SPARKLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Sparkle::checkSparkleSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(GEntityTypes.SPECTRE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void onEffecctRemoved(MobEffectEvent.Remove event) {
        HaliteCurse haliteCurse;
        MobEffectInstance effectInstance = event.getEffectInstance();
        LivingEntity living = event.getEntity();
        if (effectInstance != null && effectInstance.getEffect().is((ResourceKey)GMobEffects.HALITE_CURSE.unwrapKey().orElseThrow()) && living instanceof HaliteCurse && (haliteCurse = (HaliteCurse)living).isHaliteCursed()) {
            haliteCurse.setHaliteCurse(false);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        HaliteCurse haliteCurse;
        MobEffectInstance effectInstance = event.getEffectInstance();
        LivingEntity living = event.getEntity();
        if (effectInstance != null && effectInstance.getEffect().is((ResourceKey)GMobEffects.HALITE_CURSE.unwrapKey().orElseThrow()) && living instanceof HaliteCurse && (haliteCurse = (HaliteCurse)living).isHaliteCursed()) {
            haliteCurse.setHaliteCurse(false);
        }
    }

    @SubscribeEvent
    public static void onLivingBreath(LivingBreatheEvent event) {
        if ((Integer)event.getEntity().getData(GAttachmentTypes.GOLDEN_AIR_SUPPLY) > 0) {
            event.setCanBreathe(true);
        }
    }

    @SubscribeEvent
    public static void getProjectile(LivingGetProjectileEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack weapon = event.getProjectileWeaponItemStack();
        if (weapon.is(Items.CROSSBOW)) {
            ItemStack ammo = ProjectileWeaponItem.getHeldProjectile((LivingEntity)entity, itemStack -> true);
            if (!ammo.isEmpty()) {
                if (ammo.is((Item)GItems.GLOW_FLARE.get()) || ammo.is((Item)GItems.SPECTRE_FLARE.get())) {
                    event.setProjectileItemStack(ammo);
                }
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack itemstack1 = player.getInventory().getItem(i);
                    if (!itemstack1.is((Item)GItems.GLOW_FLARE.get()) && !itemstack1.is((Item)GItems.SPECTRE_FLARE.get())) continue;
                    event.setProjectileItemStack(itemstack1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrop(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        event.getDrops().stream().map(ItemEntity::getItem).filter(itemStack -> itemStack.has(GDataComponents.PRESERVED)).forEach(arg_0 -> ((Inventory)serverPlayer.getInventory()).add(arg_0));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        Player original = event.getOriginal();
        Inventory originalInventory = original.getInventory();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Inventory inventory = serverPlayer.getInventory();
        originalInventory.items.stream().filter(itemStack -> itemStack.has(GDataComponents.PRESERVED)).forEach(arg_0 -> ((Inventory)inventory).add(arg_0));
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        BlockEntity blockEntity = entity.level().getBlockEntity(event.getPos());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (blockEntity instanceof PreservedShulkerBox) {
                PreservedShulkerBox preservedShulkerBox = (PreservedShulkerBox)blockEntity;
                if (player.getMainHandItem().has(GDataComponents.PRESERVED.get())) {
                    preservedShulkerBox.setPreserved(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Player player = event.getPlayer();
        BlockState state = event.getState();
        if (blockEntity instanceof ShulkerBoxBlockEntity && ((PreservedShulkerBox)(shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity)).isPreserved()) {
            ItemStack stack = new ItemStack((ItemLike)ShulkerBoxBlock.getBlockByColor((DyeColor)((ShulkerBoxBlock)state.getBlock()).getColor()));
            stack.applyComponents(shulkerBoxBlockEntity.collectComponents());
            if (shulkerBoxBlockEntity.hasCustomName()) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)shulkerBoxBlockEntity.getCustomName());
            }
            stack.set(GDataComponents.PRESERVED.get(), (Object)true);
            ItemEntity itementity = new ItemEntity(player.level(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
            itementity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itementity);
            world.removeBlock(pos, false);
            state.getBlock().playerWillDestroy(player.level(), pos, state, player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeedChanged(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        if (state.getBlock() == Blocks.BUDDING_AMETHYST && ((Boolean)GalosphereConfig.SLOWED_BUDDING_AMETHYST_MINING_SPEED.get()).booleanValue()) {
            event.setNewSpeed(2.0f);
        }
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        BlockState blockState;
        ItemEntity entity = event.getEntity();
        if (!entity.level().isClientSide && (blockState = entity.level().getBlockState(BlockPos.containing((double)entity.getEyePosition().x, (double)entity.getEyePosition().y, (double)entity.getEyePosition().z))).is((Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get())) {
            event.setExtraLife(6000);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Mob mob;
        boolean flag;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float originalAmount = event.getOriginalDamage();
        EquipmentSlot[] equipmentSlotArray = source.getEntity();
        boolean bl = flag = equipmentSlotArray instanceof Mob && ((mob = (Mob)equipmentSlotArray).getType().is(EntityTypeTags.ILLAGER) || mob.getType().is(GEntityTypeTags.STERLING_IMMUNE_ENTITY_TYPES));
        if (flag) {
            Horse horse;
            if (entity instanceof Horse && (horse = (Horse)entity).getBodyArmorItem().is((Item)GItems.STERLING_HORSE_ARMOR.get())) {
                event.setNewDamage(originalAmount - 4.0f);
            }
            float illagerReduction = 0.0f;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                if (!(entity.getItemBySlot(equipmentSlot).getItem() instanceof SterlingArmorItem) || equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                illagerReduction += SterlingArmorItem.getIllagerResistance(equipmentSlot);
            }
            if (illagerReduction > 0.0f) {
                float value = 4.0f * (originalAmount / illagerReduction);
                event.setNewDamage(value);
            }
        }
    }

    private static int decreaseGoldenAirSupply(LivingEntity livingEntity, int i) {
        int reductionValue;
        AttributeInstance attributeInstance = livingEntity.getAttribute(Attributes.OXYGEN_BONUS);
        double d = attributeInstance != null ? attributeInstance.getValue() : 0.0;
        int n = reductionValue = livingEntity.isEyeInFluid(FluidTags.WATER) ? 1 : 4;
        if (d > 0.0 && livingEntity.getRandom().nextDouble() >= 1.0 / (d + 1.0)) {
            return i;
        }
        return Math.max(i - reductionValue, 0);
    }

    @SubscribeEvent
    public static void onLivingUpdate(EntityTickEvent.Pre event) {
        RopeDartProjectile projectile;
        Level mob;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ItemStack useItem = entity2.getUseItem();
        if (entity2.isAlive()) {
            int data = (Integer)entity2.getData(GAttachmentTypes.GOLDEN_AIR_SUPPLY);
            if (data > 0) {
                entity2.setData(GAttachmentTypes.GOLDEN_AIR_SUPPLY, (Object)MobEvents.decreaseGoldenAirSupply(entity2, data));
            }
            if (entity2 instanceof Mob && (mob = (Mob)entity2) instanceof HaliteCurse) {
                HaliteCurse haliteCurse = (HaliteCurse)mob;
                mob.setNoAi(haliteCurse.isHaliteCursed());
            }
        }
        if (SpectreBoundSpyglass.canUseSpectreBoundSpyglass(useItem) && !entity2.level().isClientSide && (mob = entity2.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)mob;
            Entity spectreBound = serverLevel.getEntity(((SpectreBound)useItem.get(GDataComponents.SPECTRE_BOUND.get())).uuid());
            Optional.ofNullable(spectreBound).filter(Spectre.class::isInstance).map(Spectre.class::cast).filter(LivingEntity::isAlive).ifPresent(spectre -> {
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    if (spectre.getManipulatorUUID() != player.getUUID()) {
                        boolean withinDistance;
                        boolean bl = withinDistance = Math.sqrt(Math.pow(player.getX() - spectre.getX(), 2.0) + Math.pow(player.getZ() - spectre.getZ(), 2.0)) < 110.0;
                        if (withinDistance) {
                            spectre.setCamera(player);
                        }
                    }
                }
            });
        }
        if (entity2.hasData(GAttachmentTypes.ROPE_DART) && (projectile = (RopeDartProjectile)((Object)entity2.getData(GAttachmentTypes.ROPE_DART))).inGround()) {
            float power = entity2.isInLiquid() ? 0.4f : 1.0f;
            float pullForce = 0.175f * power;
            float movementSpeed = 0.4f * power;
            float sinYRot = Mth.sin((float)(entity2.getYRot() * ((float)Math.PI / 180)));
            float cosYRot = Mth.cos((float)(entity2.getYRot() * ((float)Math.PI / 180)));
            Vec3 direction = projectile.position().subtract(entity2.getEyePosition()).normalize();
            Vec3 updated = entity2.getDeltaMovement().add(direction.multiply((double)pullForce * 0.5, (double)pullForce, (double)pullForce * 0.5));
            Vec3 vec3 = new Vec3((double)entity2.xxa, (double)entity2.yya, (double)entity2.zza);
            if ((updated = updated.add(vec3.x * (double)movementSpeed * (double)cosYRot - vec3.z * (double)movementSpeed * (double)sinYRot, 0.0, vec3.z * (double)movementSpeed * (double)cosYRot + vec3.x * (double)movementSpeed * (double)sinYRot)).lengthSqr() > 0.001) {
                updated = updated.normalize().scale(Math.min(updated.length(), 1.5));
                entity2.setDeltaMovement(updated);
                if (updated.lengthSqr() > 0.05) {
                    float volume = Mth.clamp((float)((float)updated.lengthSqr() / 2.0f), (float)0.1f, (float)0.5f);
                    entity2.level().playSound(null, entity2.getX(), entity2.getY(), entity2.getZ(), SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.NEUTRAL, volume, 1.3f + volume);
                }
            }
        }
    }
}

