/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GEnchantmentEffectComponents;
import net.orcinus.galosphere.init.GItemTags;

public class GEnchantments {
    public static final Map<ResourceLocation, ResourceKey<Enchantment>> ENCHANTMENTS = Maps.newLinkedHashMap();
    public static final ResourceKey<Enchantment> ENFEEBLE = GEnchantments.key("enfeeble");
    public static final ResourceKey<Enchantment> SUSTAIN = GEnchantments.key("sustain");
    public static final ResourceKey<Enchantment> RUPTURE = GEnchantments.key("rupture");
    public static final ResourceKey<Enchantment> SIFTING = GEnchantments.key("sifting");

    private static ResourceKey<Enchantment> key(String string) {
        ResourceLocation id = Galosphere.id(string);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id);
        ENCHANTMENTS.put(id, (ResourceKey<Enchantment>)key);
        return key;
    }

    public static void bootstrap(BootstrapContext<Enchantment> bootstrapContext) {
        HolderGetter itemHolderGetter = bootstrapContext.lookup(Registries.ITEM);
        GEnchantments.register(bootstrapContext, ENFEEBLE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(GItemTags.SALTBOUND_TABLET_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)75), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(GEnchantmentEffectComponents.SALTBOUND_TABLET_DECELERATION.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
        GEnchantments.register(bootstrapContext, SUSTAIN, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(GItemTags.SALTBOUND_TABLET_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)75), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(GEnchantmentEffectComponents.SALTBOUND_TABLET_SUSTAIN.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
        GEnchantments.register(bootstrapContext, RUPTURE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(GItemTags.SALTBOUND_TABLET_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)75), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(GEnchantmentEffectComponents.SALTBOUND_TABLET_RUPTURE.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
        GEnchantments.register(bootstrapContext, SIFTING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(Tags.Items.TOOLS_BRUSH), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)75), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(GEnchantmentEffectComponents.SIFTING.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
    }

    private static void register(BootstrapContext<Enchantment> bootstrapContext, ResourceKey<Enchantment> resourceKey, Enchantment.Builder builder) {
        bootstrapContext.register(resourceKey, (Object)builder.build(resourceKey.location()));
    }
}

