/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GArmorMaterials;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GConsumables;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GFoods;
import net.orcinus.galosphere.items.EchoBellItem;
import net.orcinus.galosphere.items.GlowFlareItem;
import net.orcinus.galosphere.items.LichenVinesBlockItem;
import net.orcinus.galosphere.items.MiningPouchItem;
import net.orcinus.galosphere.items.MonstrometerItem;
import net.orcinus.galosphere.items.OpalFlakesItem;
import net.orcinus.galosphere.items.PalladiumBombItem;
import net.orcinus.galosphere.items.PreservedFleshItem;
import net.orcinus.galosphere.items.PreservedSmithingTemplateItem;
import net.orcinus.galosphere.items.RopeDartItem;
import net.orcinus.galosphere.items.SaltboundTabletItem;
import net.orcinus.galosphere.items.SpectreBottleItem;
import net.orcinus.galosphere.items.SpectreBoundSpyglassItem;
import net.orcinus.galosphere.items.SpectreFlareItem;
import net.orcinus.galosphere.items.SterlingArmorItem;
import net.orcinus.galosphere.items.SterlingHelmetItem;
import net.orcinus.galosphere.items.SterlingHorseArmorItem;
import net.orcinus.galosphere.items.WeaponRackItem;
import net.orcinus.galosphere.items.components.AirSupplyAmplifier;
import net.orcinus.galosphere.items.components.MoleData;
import net.orcinus.galosphere.items.components.SterlingAttached;
import net.orcinus.galosphere.util.quests.IndexedQuest;

public class GItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"galosphere");
    public static final DeferredItem<Item> ICON_ITEM = GItems.register("icon_item", properties -> new Item(properties.stacksTo(0)));
    public static final DeferredItem<Item> FAITH_ARMOR_TRIM_SMITHING_TEMPLATE = GItems.register("faith_armor_trim_smithing_template", properties -> SmithingTemplateItem.createArmorTrimTemplate((Item.Properties)properties.rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> BROKEN_ECHO_BELL = GItems.register("broken_echo_bell", properties -> new Item(properties.rarity(Rarity.RARE)));
    public static final DeferredItem<Item> PRESERVED_TEMPLATE = GItems.register("preserved_template", properties -> new PreservedSmithingTemplateItem(properties.rarity(Rarity.RARE)));
    public static final DeferredItem<Item> SALTBOUND_TABLET = GItems.register("saltbound_tablet", properties -> new SaltboundTabletItem(properties.stacksTo(1).durability(432).rarity(Rarity.EPIC)));
    public static final DeferredItem<Item> SHRINE_KEY = GItems.register("shrine_key", Item::new);
    public static final DeferredItem<Item> ECHO_BELL = GItems.register("echo_bell", properties -> new EchoBellItem(properties.stacksTo(1).durability(432).rarity(Rarity.RARE)));
    public static final DeferredItem<Item> ROPE_DART = GItems.register("rope_dart", RopeDartItem::new);
    public static final DeferredItem<Item> THIRST_POTTERY_SHERD = GItems.register("thirst_pottery_sherd", properties -> new Item(properties.rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> WAVE_POTTERY_SHERD = GItems.register("wave_pottery_sherd", properties -> new Item(properties.rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> OPAL_FLAKES = GItems.register("opal_flakes", OpalFlakesItem::new);
    public static final DeferredItem<Item> SPARKLE_SPAWN_EGG = GItems.register("sparkle_spawn_egg", properties -> new SpawnEggItem(GEntityTypes.SPARKLE.get(), properties));
    public static final DeferredItem<Item> SPECTRE_SPAWN_EGG = GItems.register("spectre_spawn_egg", properties -> new SpawnEggItem(GEntityTypes.SPECTRE.get(), properties));
    public static final DeferredItem<Item> SPECTERPILLAR_SPAWN_EGG = GItems.register("specterpillar_spawn_egg", properties -> new SpawnEggItem(GEntityTypes.SPECTERPILLAR.get(), properties));
    public static final DeferredItem<Item> BERSERKER_SPAWN_EGG = GItems.register("berserker_spawn_egg", properties -> new SpawnEggItem(GEntityTypes.BERSERKER.get(), properties));
    public static final DeferredItem<Item> PRESERVED_SPAWN_EGG = GItems.register("preserved_spawn_egg", properties -> new SpawnEggItem(GEntityTypes.PRESERVED.get(), properties));
    public static final DeferredItem<Item> MOLE_SPAWN_EGG = GItems.register("mole_spawn_egg", properties -> new SpawnEggItem(GEntityTypes.MOLE.get(), properties));
    public static final DeferredItem<Item> STERLING_HELMET = GItems.register("sterling_helmet", properties -> new SterlingHelmetItem(properties.component(GDataComponents.STERLING_ATTACHED.get(), (Object)SterlingAttached.EMPTY).stacksTo(1).durability(156)));
    public static final DeferredItem<Item> STERLING_CHESTPLATE = GItems.register("sterling_chestplate", properties -> new SterlingArmorItem(ArmorType.CHESTPLATE, properties.stacksTo(1).durability(180)));
    public static final DeferredItem<Item> STERLING_LEGGINGS = GItems.register("sterling_leggings", properties -> new SterlingArmorItem(ArmorType.LEGGINGS, properties.stacksTo(1).durability(192)));
    public static final DeferredItem<Item> STERLING_BOOTS = GItems.register("sterling_boots", properties -> new SterlingArmorItem(ArmorType.BOOTS, properties.stacksTo(1).durability(132)));
    public static final DeferredItem<Item> STERLING_HORSE_ARMOR = GItems.register("sterling_horse_armor", properties -> new SterlingHorseArmorItem(GArmorMaterials.STERLING, AnimalArmorItem.BodyType.EQUESTRIAN, (Holder<SoundEvent>)SoundEvents.HORSE_ARMOR, false, (Item.Properties)properties));
    public static final DeferredItem<Item> ALLURITE_SHARD = GItems.register("allurite_shard", Item::new);
    public static final DeferredItem<Item> LUMIERE_SHARD = GItems.register("lumiere_shard", Item::new);
    public static final DeferredItem<Item> PINK_SALT_SHARD = GItems.register("pink_salt_shard", Item::new);
    public static final DeferredItem<Item> BOTTLE_OF_SPECTRE = GItems.register("bottle_of_spectre", properties -> new SpectreBottleItem(properties.stacksTo(1)));
    public static final DeferredItem<Item> RAW_PALLADIUM = GItems.register("raw_palladium", Item::new);
    public static final DeferredItem<Item> PALLADIUM_INGOT = GItems.register("palladium_ingot", Item::new);
    public static final DeferredItem<Item> PALLADIUM_NUGGET = GItems.register("palladium_nugget", Item::new);
    public static final DeferredItem<Item> PALLADIUM_BOMB = GItems.register("palladium_bomb", PalladiumBombItem::new);
    public static final DeferredItem<Item> SALTED_JERKY = GItems.register("salted_jerky", properties -> new Item(properties.food(GFoods.SALTED_JERKY)));
    public static final DeferredItem<Item> PRESERVED_FLESH = GItems.register("preserved_flesh", properties -> new PreservedFleshItem(properties.stacksTo(1).durability(180).rarity(Rarity.RARE).food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.1f).build()).repairable(Items.ROTTEN_FLESH)));
    public static final DeferredItem<Item> CURED_MEMBRANE = GItems.register("cured_membrane", Item::new);
    public static final DeferredItem<Item> LICHEN_CORDYCEPS = GItems.register("lichen_cordyceps", properties -> new BlockItem((Block)GBlocks.LICHEN_CORDYCEPS.get(), properties.useItemDescriptionPrefix().food(GFoods.LICHEN_CORDYCEPS, GConsumables.LICHEN_CORDYCEPS).component(GDataComponents.AIR_SUPPLY_AMPLIFIER.get(), (Object)new AirSupplyAmplifier(60))));
    public static final DeferredItem<Item> GOLDEN_LICHEN_CORDYCEPS = GItems.register("golden_lichen_cordyceps", properties -> new Item(properties.food(GFoods.GOLDEN_LICHEN_CORDYCEPS, GConsumables.LICHEN_CORDYCEPS).component(GDataComponents.AIR_SUPPLY_AMPLIFIER.get(), (Object)new AirSupplyAmplifier(120, 300))));
    public static final DeferredItem<Item> GLOW_FLARE = GItems.register("glow_flare", GlowFlareItem::new);
    public static final DeferredItem<Item> SPECTRE_FLARE = GItems.register("spectre_flare", SpectreFlareItem::new);
    public static final DeferredItem<Item> SPECTRE_BOUND_SPYGLASS = GItems.register("spectre_bound_spyglass", properties -> new SpectreBoundSpyglassItem(properties.stacksTo(1)));
    public static final DeferredItem<Item> MONSTROMETER = GItems.register("monstrometer", properties -> new MonstrometerItem(properties.stacksTo(1)));
    public static final DeferredItem<Item> MINING_POUCH = GItems.register("mining_pouch", properties -> new MiningPouchItem(properties.stacksTo(1).component(GDataComponents.QUESTS.get(), (Object)IndexedQuest.EMPTY)));
    public static final DeferredItem<Item> LIGHT_STAND = GItems.register("light_stand", properties -> new DoubleHighBlockItem((Block)GBlocks.LIGHT_STAND.get(), properties));
    public static final DeferredItem<Item> SOUL_LIGHT_STAND = GItems.register("soul_light_stand", properties -> new DoubleHighBlockItem((Block)GBlocks.SOUL_LIGHT_STAND.get(), properties));
    public static final DeferredItem<Item> MOLE_BURROW = GItems.register("mole_burrow", properties -> new BlockItem((Block)GBlocks.MOLE_BURROW.get(), properties.component(GDataComponents.MOLE.get(), (Object)MoleData.EMPTY)));
    public static final DeferredItem<Item> LICHEN_VINES = GItems.register("lichen_vines", properties -> new LichenVinesBlockItem((Block)GBlocks.LICHEN_VINES.get(), (Item.Properties)properties));
    public static final DeferredItem<Item> OPAL = GItems.register("opal", Item::new);
    public static final DeferredItem<Item> WEAPON_RACK = GItems.register("weapon_rack", WeaponRackItem::new);
    public static final DeferredItem<Item> SILVERFISH = GItems.register("silverfish", Item::new);

    public static DeferredItem<Item> register(String name, Function<Item.Properties, Item> function) {
        return ITEMS.register(name, () -> (Item)function.apply(new Item.Properties().setId(GItems.key(name))));
    }

    private static ResourceKey<Item> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Galosphere.id(name));
    }
}

