/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.ai.MoleAi;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.entities.ai.SpectreAi;
import net.orcinus.galosphere.entities.ai.sensors.BerserkerEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.MoleEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.NearestBlockSensor;
import net.orcinus.galosphere.entities.ai.sensors.PreservedEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.RepellentSensor;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class GSensorTypes {
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((ResourceKey)Registries.SENSOR_TYPE, (String)"galosphere");
    public static final Supplier<SensorType<TemptingSensor>> SPARKLE_TEMPTATIONS = SENSOR_TYPES.register("sparkle_temptations", () -> new SensorType(() -> new TemptingSensor(SparkleAi.getTemptations())));
    public static final Supplier<SensorType<TemptingSensor>> SPECTRE_TEMPTATIONS = SENSOR_TYPES.register("spectre_temptations", () -> new SensorType(() -> new TemptingSensor(SpectreAi.getTemptations())));
    public static final Supplier<SensorType<TemptingSensor>> MOLE_TEMPTATIONS = SENSOR_TYPES.register("mole_temptations", () -> new SensorType(() -> new TemptingSensor(MoleAi.getTemptations())));
    public static final Supplier<SensorType<RepellentSensor>> MOLE_REPELLENTS = SENSOR_TYPES.register("mole_repellents", () -> new SensorType(() -> new RepellentSensor(MoleAi::validRepellent)));
    public static final Supplier<SensorType<NearestBlockSensor>> NEAREST_POLLINATED_CLUSTER = SENSOR_TYPES.register("nearest_pollinated_cluster", () -> new SensorType(() -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get(), Sparkle::isValidTargetState)));
    public static final Supplier<SensorType<NearestBlockSensor>> NEAREST_LICHEN_MOSS = SENSOR_TYPES.register("nearest_lichen_moss", () -> new SensorType(() -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get(), GMemoryModuleTypes.CAN_BURY.get(), Specterpillar::isValidTargetState)));
    public static final Supplier<SensorType<NearestBlockSensor>> NEAREST_MOLE_BURROW = SENSOR_TYPES.register("nearest_mole_burrow", () -> new SensorType(() -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_MOLE_BURROW.get(), Mole::isValidTargetState)));
    public static final Supplier<SensorType<NearestBlockSensor>> NEAREST_TUFF_DIRT = SENSOR_TYPES.register("nearest_tuff_dirt", () -> new SensorType(() -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_TUFF_DIRT.get(), Mole::isTuffDirt)));
    public static final Supplier<SensorType<BerserkerEntitySensor>> BERSERKER_ENTITY_SENSOR = SENSOR_TYPES.register("berserker_entity_sensor", () -> new SensorType(BerserkerEntitySensor::new));
    public static final Supplier<SensorType<PreservedEntitySensor>> PRESERVED_ENTITY_SENSOR = SENSOR_TYPES.register("preserved_entity_sensor", () -> new SensorType(PreservedEntitySensor::new));
    public static final Supplier<SensorType<MoleEntitySensor>> MOLE_ENTITY_SENSOR = SENSOR_TYPES.register("mole_entity_sensor", () -> new SensorType(MoleEntitySensor::new));
}

