/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.items.components.EchobellTracker;
import net.orcinus.galosphere.util.HandbellManager;
import org.apache.commons.lang3.math.Fraction;

public class EchoBellItem
extends Item {
    private static final int MAX_FUEL = 4;
    public static final int MAX_USE_TIME = 1200;
    private static final int BAR_COLOR = ARGB.color((Vec3)Vec3.fromRGB24((int)0x65FFFF));
    public static final Component INSERT_FUEL = Component.translatable((String)"item.galosphere.echo_bell.description");

    public EchoBellItem(Item.Properties properties) {
        super(properties);
    }

    public int getBarColor(ItemStack itemStack) {
        return BAR_COLOR;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        return EchoBellItem.getFuelBarWidth(itemStack);
    }

    private static int getFuelBarWidth(ItemStack stack) {
        EchobellTracker tracker = (EchobellTracker)stack.get(GDataComponents.ECHO_BELL_TRACKER.get());
        return tracker == null ? 0 : Mth.clamp((int)Mth.mulAndTruncate((Fraction)Fraction.getFraction((int)tracker.fuel(), (int)4), (int)13), (int)0, (int)13);
    }

    public boolean overrideOtherStackedOnMe(ItemStack itemStack, ItemStack itemStack2, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        int ringerFuel;
        if (clickAction != ClickAction.PRIMARY || !slot.allowModification(player)) {
            return false;
        }
        EchobellTracker tracker = (EchobellTracker)itemStack.get(GDataComponents.ECHO_BELL_TRACKER.get());
        int n = ringerFuel = tracker == null ? 0 : tracker.fuel();
        if (itemStack2.is(GItemTags.HANDBELL_FUEL) && ringerFuel < 4) {
            int shrinkAmount = itemStack2.getCount();
            int combinedFuel = ringerFuel + itemStack2.getCount();
            int newFuel = Math.min(4, combinedFuel);
            if (combinedFuel > 4) {
                shrinkAmount -= combinedFuel - 4;
            }
            itemStack2.shrink(shrinkAmount);
            EchobellTracker newTracker = tracker != null ? new EchobellTracker(newFuel, tracker.activated(), tracker.ticks()) : new EchobellTracker(newFuel, false, 1200);
            itemStack.set(GDataComponents.ECHO_BELL_TRACKER.get(), (Object)newTracker);
            player.playSound(GSoundEvents.MONSTROMETER_CHARGE.get(), 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        int fuel;
        ItemStack itemStack = player.getItemInHand(interactionHand);
        EchobellTracker minersBell = (EchobellTracker)itemStack.get(GDataComponents.ECHO_BELL_TRACKER.get());
        if (minersBell != null && (fuel = minersBell.fuel()) > 0) {
            int gameTime = (int)level.getGameTime();
            EchobellTracker newMinersBell = new EchobellTracker(fuel, !minersBell.activated(), gameTime + 1200);
            itemStack.set(GDataComponents.ECHO_BELL_TRACKER.get(), (Object)newMinersBell);
            player.playSound(minersBell.activated() ? SoundEvents.CONDUIT_DEACTIVATE : SoundEvents.CONDUIT_ACTIVATE, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.use(level, player, interactionHand);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        EchobellTracker tracker = (EchobellTracker)itemStack.get(GDataComponents.ECHO_BELL_TRACKER.get());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (tracker != null && tracker.shouldActivate()) {
                    RandomSource random = player.getRandom();
                    int xzRange = 5;
                    int yRange = 3;
                    int particleRange = Mth.nextInt((RandomSource)random, (int)6, (int)8);
                    if (HandbellManager.shouldResonate(player)) {
                        HandbellManager.resonance(serverLevel, player, random, xzRange, yRange, particleRange);
                    }
                }
            }
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)INSERT_FUEL.copy().withStyle(ChatFormatting.GRAY));
    }
}

