/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.items.components.MonstrometerTracker;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class MonstrometerItem
extends Item {
    private static final int MAX_FUEL = 4;
    private static final int MAX_USE_TIME = 52;
    private static final int DECREMENT_USE_TIME_INTERVAL = 30;
    private static final int LUMIERE_FUEL_BAR_COLOR = ARGB.color((Vec3)Vec3.fromRGB24((int)16757273));
    public static final Component INSERT_FUEL = Component.translatable((String)"item.galosphere.monstrometer.description");

    public MonstrometerItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    private static MonstrometerTracker getMonstrometerTracker(ItemStack stack) {
        return (MonstrometerTracker)stack.get(GDataComponents.MONSTROMETER_TRACKER);
    }

    public static List<BlockPos> getIndicatedBlocks(BlockPos pos, Predicate<BlockPos> predicate) {
        int radius = 20;
        int height = 6;
        ArrayList list = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    if (x * x + z * z > radius * radius) continue;
                    list.add(pos.offset(x, y, z));
                }
            }
        }
        return list.stream().filter(predicate).toList();
    }

    public static List<LivingEntity> getNearbyMonsters(Level level, BlockPos pos) {
        return level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(16.0, 6.0, 16.0), livingEntity -> livingEntity.isAlive() && livingEntity instanceof Monster);
    }

    public static boolean isUnsafe(Level level, BlockPos pos) {
        return level.getBrightness(LightLayer.BLOCK, pos) <= level.dimensionType().monsterSpawnBlockLightLimit();
    }

    public int getBarColor(ItemStack stack) {
        return LUMIERE_FUEL_BAR_COLOR;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean bl) {
        if (this.isActive(stack) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
            if (level.getGameTime() % 30L == 0L) {
                Predicate<BlockPos> predicate = pos -> level.isEmptyBlock(pos) && level.getBlockState(pos.below()).isSolidRender() && NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), (FluidState)level.getFluidState(pos), (EntityType)EntityType.ZOMBIE);
                MonstrometerItem.getIndicatedBlocks(entity.blockPosition(), predicate).forEach(pos -> {
                    double x = (double)pos.getX() + 0.5;
                    double y = (float)pos.getY() + 0.01f;
                    double z = (double)pos.getZ() + 0.5;
                    serverLevel.sendParticles((ParticleOptions)GParticleTypes.MONSTROMETER_INDICATOR.get(), x, y, z, 1, 0.0, 0.0, 0.0, 0.5);
                });
                MonstrometerItem.getNearbyMonsters(level, entity.blockPosition()).forEach(mob -> mob.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60)));
                int decremented = tracker.useTime() - 1;
                if (decremented == 0) {
                    level.playSound(entity, entity.blockPosition(), GSoundEvents.MONSTROMETER_DEACTIVATE.get(), entity.getSoundSource(), 1.0f, 1.0f);
                }
                stack.set(GDataComponents.MONSTROMETER_TRACKER, (Object)MonstrometerTracker.of(decremented == 0 ? tracker.fuel() - 1 : tracker.fuel(), decremented));
            }
        }
    }

    public int getBarWidth(ItemStack stack) {
        return MonstrometerItem.getFuelBarWidth(stack);
    }

    private boolean isActive(ItemStack stack) {
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        return tracker != null && tracker.useTime() > 0;
    }

    private static int getFuelBarWidth(ItemStack stack) {
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        return tracker == null ? 0 : Mth.clamp((int)Mth.mulAndTruncate((Fraction)Fraction.getFraction((int)tracker.fuel(), (int)4), (int)13), (int)0, (int)13);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        int fuel;
        if (action != ClickAction.PRIMARY || !slot.allowModification(player)) {
            return false;
        }
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        int n = fuel = tracker != null ? tracker.fuel() : 0;
        if (other.is(GItemTags.MONSTROMETER_FUEL) && fuel < 4) {
            int shrinkAmount = other.getCount();
            int combinedFuel = fuel + other.getCount();
            if (combinedFuel > 4) {
                shrinkAmount -= combinedFuel - 4;
            }
            other.shrink(shrinkAmount);
            stack.set(GDataComponents.MONSTROMETER_TRACKER, (Object)MonstrometerTracker.updateFuel(tracker, Math.min(4, combinedFuel)));
            player.playSound(GSoundEvents.MONSTROMETER_CHARGE.get(), 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        if (tracker != null && tracker.fuel() > 0 && !this.isActive(stack)) {
            stack.set(GDataComponents.MONSTROMETER_TRACKER, (Object)MonstrometerTracker.updateUseTime(tracker, 52));
            player.getCooldowns().addCooldown(stack, 1560);
            player.playSound(GSoundEvents.MONSTROMETER_ACTIVATE.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)INSERT_FUEL.copy().withStyle(ChatFormatting.GRAY));
    }
}

