/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.network.SendOpalParticlePacket;

public class OpalFlakesItem
extends Item {
    public OpalFlakesItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        ItemStack itemStack = useOnContext.getItemInHand();
        BlockPos blockPos = useOnContext.getClickedPos();
        Level level = useOnContext.getLevel();
        BlockState blockState = level.getBlockState(blockPos);
        Player player = useOnContext.getPlayer();
        if (player != null && blockState.is(BlockTags.SAPLINGS) && !blockState.is((Block)GBlocks.OPAL_SAPLING.get())) {
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            itemStack.consume(1, (LivingEntity)player);
            OpalFlakesItem.convertSapling(level, blockPos, player);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(useOnContext);
    }

    public static void convertSapling(Level level, BlockPos blockPos, Player player) {
        level.setBlock(blockPos, ((Block)GBlocks.OPAL_SAPLING.get()).defaultBlockState(), 2);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SendOpalParticlePacket(blockPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

