/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.entities.PalladiumBomb;
import net.orcinus.galosphere.init.GDataComponents;

public class PalladiumBombItem
extends Item {
    public PalladiumBombItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown(itemstack, 10);
        if (!world.isClientSide()) {
            PalladiumBomb bomb = new PalladiumBomb(world, (LivingEntity)player, itemstack);
            bomb.setItem(itemstack);
            bomb.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 1.0f);
            world.addFreshEntity((Entity)bomb);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        String text = "item.galosphere.palladium_bomb.";
        if (this.getModifierValue(itemStack, GDataComponents.DURATION.get()) > 0) {
            list.add((Component)Component.translatable((String)(text + "duration")).append(" ").append(String.valueOf(this.getModifierValue(itemStack, GDataComponents.DURATION.get()))).withStyle(ChatFormatting.GRAY));
        }
        if (this.getModifierValue(itemStack, GDataComponents.BOUNCY.get()) > 0) {
            list.add((Component)Component.translatable((String)(text + "bouncy")).append(" ").append(String.valueOf(this.getModifierValue(itemStack, GDataComponents.BOUNCY.get()))).withStyle(ChatFormatting.GRAY));
        }
        if (this.getModifierValue(itemStack, GDataComponents.EXPLOSION.get()) > 0) {
            list.add((Component)Component.translatable((String)(text + "explosion")).append(" ").append(String.valueOf(this.getModifierValue(itemStack, GDataComponents.EXPLOSION.get()))).withStyle(ChatFormatting.GRAY));
        }
    }

    private int getModifierValue(ItemStack stack, DataComponentType<Integer> dataComponentType) {
        return (Integer)stack.getOrDefault(dataComponentType, (Object)0);
    }
}

