/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.init.GCriteriaTriggers;

public class SpectreBoundSpyglassItem
extends Item {
    public SpectreBoundSpyglassItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 1200;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.SPYGLASS;
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (!SpectreBoundSpyglass.canUseSpectreBoundSpyglass(player.getItemInHand(interactionHand))) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!level.isClientSide) {
                GCriteriaTriggers.USE_SPECTRE_SPYGLASS.get().trigger(serverPlayer);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        player.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        this.stopUsing(itemStack, livingEntity);
        return itemStack;
    }

    public boolean releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        this.stopUsing(itemStack, livingEntity);
        return true;
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    private void stopUsing(ItemStack itemStack, LivingEntity livingEntity) {
        livingEntity.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCooldowns().addCooldown(itemStack, 20);
        }
    }
}

