/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.orcinus.galosphere.entities.WeaponRack;

public class WeaponRackItem
extends Item {
    public WeaponRackItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockPos blockPos = useOnContext.getClickedPos();
        Direction direction = useOnContext.getClickedFace();
        BlockPos blockPos2 = blockPos.relative(direction);
        Player player = useOnContext.getPlayer();
        ItemStack itemStack = useOnContext.getItemInHand();
        if (player != null && !this.mayPlace(player, direction, itemStack, blockPos2)) {
            return InteractionResult.FAIL;
        }
        Level level = useOnContext.getLevel();
        WeaponRack weaponRack = new WeaponRack(level, blockPos2, direction);
        weaponRack.setRotation(1);
        EntityType.createDefaultStackConfig((Level)level, (ItemStack)itemStack, (Player)player).accept(weaponRack);
        if (weaponRack.survives()) {
            if (!level.isClientSide) {
                weaponRack.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, weaponRack.position());
                level.addFreshEntity((Entity)weaponRack);
            }
            itemStack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack itemStack, BlockPos blockPos) {
        return !player.level().isOutsideBuildHeight(blockPos) && player.mayUseItemAt(blockPos, direction, itemStack);
    }
}

