/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GMobEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin {
    @Inject(at={@At(value="RETURN")}, method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void G$getCollisionShape(BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (collisionContext instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)collisionContext).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((BlockBehaviour.BlockStateBase)this).isSolidRender()) {
                boolean flag;
                boolean above = livingEntity.getY() > (double)blockPos.getY() + ((VoxelShape)cir.getReturnValue()).max(Direction.Axis.Y) - (double)(livingEntity.onGround() ? 0.5f : 0.001f);
                boolean bl = flag = !above || livingEntity.isShiftKeyDown();
                if (livingEntity.hasEffect(GMobEffects.ASTRAL) && flag && !blockGetter.getBlockState(blockPos).is(GBlockTags.OMIT_ASTRAL)) {
                    cir.setReturnValue((Object)Shapes.empty());
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"entityInside"}, cancellable=true)
    private void G$entityInside(Level level, BlockPos blockPos, Entity entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(GMobEffects.ASTRAL) && !level.getBlockState(blockPos).is(GBlockTags.OMIT_ASTRAL)) {
            ci.cancel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (((BlockBehaviour.BlockStateBase)this).isSolid()) {
                    boolean bl = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
                    RandomSource randomSource = level.getRandom();
                    if (bl && randomSource.nextBoolean()) {
                        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, level.getBlockState(blockPos)), entity.getX(), (double)(blockPos.getY() + 1), entity.getZ(), 1, (double)(Mth.randomBetween((RandomSource)randomSource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)randomSource, (float)-1.0f, (float)1.0f) * 0.083333336f), 0.0);
                    }
                }
            }
        }
    }
}

