/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.events.ClientEvents;
import net.orcinus.galosphere.mixin.EntityRendererAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<S>> {
    @Shadow
    protected M model;
    @Shadow
    @Final
    protected List<RenderLayer<S, M>> layers;

    @Shadow
    public abstract ResourceLocation getTextureLocation(S var1);

    @Shadow
    protected abstract float getWhiteOverlayProgress(S var1);

    @Shadow
    protected abstract boolean shouldRenderLayers(S var1);

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V")}, method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void G$render(S livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (((Boolean)livingEntityRenderState.getRenderDataOrDefault(ClientEvents.TRANSLUCENT, (Object)false)).booleanValue()) {
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(livingEntityRenderState)));
            int j = LivingEntityRenderer.getOverlayCoords(livingEntityRenderState, (float)this.getWhiteOverlayProgress(livingEntityRenderState));
            int translucence = ARGB.colorFromFloat((float)0.35f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.model.renderToBuffer(poseStack, vertexConsumer, i, j, translucence);
            if (this.shouldRenderLayers(livingEntityRenderState)) {
                this.layers.forEach(smRenderLayer -> smRenderLayer.render(poseStack, multiBufferSource, i, (EntityRenderState)livingEntityRenderState, livingEntityRenderState.yRot, livingEntityRenderState.xRot));
            }
            poseStack.popPose();
            EntityRendererAccessor accessor1 = (EntityRendererAccessor)((Object)this);
            if (((LivingEntityRenderState)livingEntityRenderState).leashState != null) {
                EntityRenderer.renderLeash((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (EntityRenderState.LeashState)((LivingEntityRenderState)livingEntityRenderState).leashState);
            }
            if (((LivingEntityRenderState)livingEntityRenderState).nameTag != null) {
                accessor1.callRenderNameTag(livingEntityRenderState, ((LivingEntityRenderState)livingEntityRenderState).nameTag, poseStack, multiBufferSource, i);
            }
            ci.cancel();
        }
    }
}

