/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util.quests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootTable;

public record MiningQuest(int weight, Rarity rarity, ResourceKey<LootTable> required, ResourceKey<LootTable> gift) {
    public static final Codec<MiningQuest> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(MiningQuest::weight), (App)Rarity.CODEC.fieldOf("rarity").forGetter(MiningQuest::rarity), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("required").forGetter(MiningQuest::required), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("gift").forGetter(MiningQuest::gift)).apply((Applicative)instance, MiningQuest::new));
    public static final Codec<MiningQuest> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(MiningQuest::weight), (App)Rarity.CODEC.fieldOf("rarity").forGetter(MiningQuest::rarity), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("required").forGetter(MiningQuest::required), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("gift").forGetter(MiningQuest::gift)).apply((Applicative)instance, MiningQuest::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MiningQuest> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MiningQuest>(){

        public MiningQuest decode(RegistryFriendlyByteBuf object) {
            int weight = object.readInt();
            Rarity rarity = (Rarity)Rarity.STREAM_CODEC.decode((Object)object);
            ResourceKey required = (ResourceKey)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).decode((Object)object);
            ResourceKey gift = (ResourceKey)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).decode((Object)object);
            return new MiningQuest(weight, rarity, (ResourceKey<LootTable>)required, (ResourceKey<LootTable>)gift);
        }

        public void encode(RegistryFriendlyByteBuf object, MiningQuest object2) {
            object.writeInt(object2.weight);
            Rarity.STREAM_CODEC.encode((Object)object, (Object)object2.rarity);
            ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).encode((Object)object, object2.required);
            ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).encode((Object)object, object2.gift);
        }
    };
}

