/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.orcinus.galosphere.init.GBlocks;

public class LichenMushroomFeature
extends Feature<NoneFeatureConfiguration> {
    public LichenMushroomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        int radius = Mth.nextInt((RandomSource)random, (int)2, (int)4);
        int height = radius * 2;
        int tries = 0;
        HashSet set = Sets.newHashSet();
        return !this.generateLichenMushroom(world, blockPos, random, radius, height, set, tries);
    }

    private boolean generateLichenMushroom(WorldGenLevel world, BlockPos blockPos, RandomSource random, int radius, int stemHeight, HashSet<BlockPos> set, int tries) {
        for (int checkx = -radius; checkx <= radius; ++checkx) {
            for (int checkz = -radius; checkz <= radius; ++checkz) {
                boolean flag = checkx == -radius || checkx == radius;
                boolean flag1 = checkz == -radius || checkz == radius;
                boolean flag2 = flag && flag1;
                BlockPos checkpos = new BlockPos(blockPos.getX() + checkx, blockPos.getY() - 1, blockPos.getZ() + checkz);
                if (!world.isEmptyBlock(checkpos) && world.getFluidState(checkpos).isEmpty() || flag2) continue;
                if (++tries < 5) {
                    return this.generateLichenMushroom(world, blockPos.below(), random, radius, stemHeight, set, tries);
                }
                return false;
            }
        }
        LichenMushroomFeature.generateHugeLichenMushroom(world, blockPos, random, radius, stemHeight, set);
        return false;
    }

    public static boolean generateHugeLichenMushroom(WorldGenLevel world, BlockPos blockPos, RandomSource random, int radius, int stemHeight, HashSet<BlockPos> set) {
        if (!LichenMushroomFeature.checkAirExposure((LevelAccessor)world, blockPos, stemHeight)) {
            return false;
        }
        if (radius == 1) {
            LichenMushroomFeature.generateUnqiueLichenMushroom(world, blockPos, set);
        } else {
            LichenMushroomFeature.generateDefaultLichenMushroom(world, blockPos, radius, stemHeight, set);
        }
        set.forEach(mossPos -> {
            Direction randomDir;
            Direction direction;
            if (random.nextInt(3) == 0 && world.isStateAtPosition(mossPos.above(), DripstoneUtils::isEmptyOrWater)) {
                Block block = random.nextBoolean() ? (Block)GBlocks.BOWL_LICHEN.get() : (Block)GBlocks.LICHEN_ROOTS.get();
                world.setBlock(mossPos.above(), (BlockState)block.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getBlockState(mossPos.above()).is(Blocks.WATER))), 2);
            }
            if (world.isStateAtPosition(mossPos.relative(direction = Direction.Plane.HORIZONTAL.getRandomDirection(random)), LichenMushroomFeature::canGenerate) && random.nextInt(3) == 0) {
                world.setBlock(mossPos.relative(direction), (BlockState)((BlockState)((Block)GBlocks.LICHEN_SHELF.get()).defaultBlockState().setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)direction)).setValue((Property)BaseCoralWallFanBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(mossPos.relative(direction)).is(FluidTags.WATER))), 2);
            }
            if (world.isStateAtPosition(mossPos.relative(randomDir = Direction.getRandom((RandomSource)random)), LichenMushroomFeature::canGenerate) && random.nextInt(3) == 0) {
                world.setBlock(mossPos.relative(randomDir), (BlockState)((BlockState)Blocks.GLOW_LICHEN.defaultBlockState().setValue((Property)GlowLichenBlock.getFaceProperty((Direction)randomDir.getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(mossPos.relative(randomDir)).is(FluidTags.WATER))), 2);
            }
        });
        return true;
    }

    private static void generateUnqiueLichenMushroom(WorldGenLevel world, BlockPos blockPos, HashSet<BlockPos> set) {
        int z;
        int x;
        int stemRadius = 1;
        int capRadius = 2;
        int radiusOneHeight = 3;
        for (x = -stemRadius; x <= stemRadius; ++x) {
            for (z = -stemRadius; z <= stemRadius; ++z) {
                BlockPos generatePos = new BlockPos(blockPos.getX() + x, blockPos.getY(), blockPos.getZ() + z);
                for (int y = 0; y < radiusOneHeight; ++y) {
                    boolean flag1;
                    BlockPos pos = generatePos.above(y);
                    boolean flag = x == stemRadius || x == -stemRadius;
                    boolean bl = flag1 = z == stemRadius || z == -stemRadius;
                    if (y != 1 ? y == 2 && (flag || flag1) : flag && flag1) continue;
                    if (!world.isStateAtPosition(pos, LichenMushroomFeature::canGenerate)) continue;
                    world.setBlock(pos, Blocks.MUSHROOM_STEM.defaultBlockState(), 2);
                }
                BlockPos capPos = generatePos.above(radiusOneHeight);
                if (!world.isStateAtPosition(capPos, LichenMushroomFeature::canGenerate)) continue;
                world.setBlock(capPos, ((Block)GBlocks.LICHEN_MOSS.get()).defaultBlockState(), 2);
                set.add(capPos);
            }
        }
        for (x = -capRadius; x <= capRadius; ++x) {
            for (z = -capRadius; z <= capRadius; ++z) {
                boolean flag;
                BlockPos capPos = new BlockPos(blockPos.getX() + x, blockPos.getY() + radiusOneHeight + 1, blockPos.getZ() + z);
                boolean bl = flag = !(x != capRadius && x != -capRadius || z != capRadius && z != -capRadius);
                if (flag || x * x + z * z <= 1 || !world.isStateAtPosition(capPos, LichenMushroomFeature::canGenerate)) continue;
                world.setBlock(capPos, ((Block)GBlocks.LICHEN_MOSS.get()).defaultBlockState(), 2);
                set.add(capPos);
            }
        }
    }

    private static boolean canGenerate(BlockState state) {
        return state.canBeReplaced() || state.isAir() || state.is(Blocks.WATER) || state.is((Block)GBlocks.BOWL_LICHEN.get());
    }

    private static void generateDefaultLichenMushroom(WorldGenLevel world, BlockPos blockPos, int radius, int stemHeight, HashSet<BlockPos> set) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    boolean flag2;
                    BlockPos pos = new BlockPos(blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z);
                    int f4 = 4 * radius;
                    boolean flag = x == -radius || x == radius;
                    boolean flag1 = z == -radius || z == radius;
                    boolean bl = flag2 = y == 0 && flag && flag1;
                    if (!((double)(x * x) + 2.0 * (Math.log(y * y) * (double)f4) / (double)f4 + (double)(z * z) <= (double)(radius * radius)) || flag2) continue;
                    if (world.isStateAtPosition(pos, LichenMushroomFeature::canGenerate)) {
                        world.setBlock(pos, Blocks.MUSHROOM_STEM.defaultBlockState(), 2);
                    }
                    for (int xMossRadius = -radius * 2; xMossRadius <= radius * 2; ++xMossRadius) {
                        for (int zMossRadius = -radius * 2; zMossRadius <= radius * 2; ++zMossRadius) {
                            BlockPos mossPos = new BlockPos(blockPos.getX() + xMossRadius, blockPos.getY() + stemHeight - 1, blockPos.getZ() + zMossRadius);
                            int distance = xMossRadius * xMossRadius + zMossRadius * zMossRadius;
                            if (distance < radius * 4) {
                                if (!world.isStateAtPosition(mossPos, LichenMushroomFeature::canGenerate)) continue;
                                world.setBlock(mossPos, ((Block)GBlocks.LICHEN_MOSS.get()).defaultBlockState(), 2);
                                set.add(mossPos);
                                continue;
                            }
                            if (distance > radius * 8 || distance < radius * 4 || !world.isStateAtPosition(mossPos.above(), LichenMushroomFeature::canGenerate)) continue;
                            world.setBlock(mossPos.above(), ((Block)GBlocks.LICHEN_MOSS.get()).defaultBlockState(), 2);
                            set.add(mossPos.above());
                        }
                    }
                }
            }
        }
    }

    public static boolean checkAirExposure(LevelAccessor world, BlockPos blockPos, int height) {
        for (int y = 0; y < height; ++y) {
            if (!world.isStateAtPosition(blockPos.above(y), LichenMushroomFeature::canGenerate)) continue;
            return true;
        }
        return false;
    }
}

