/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1427;
import net.minecraft.class_1569;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.orcinus.galosphere.api.HaliteCurse;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class HaliteAttack
extends class_4097<Berserker> {
    private static final int MAX_DURATION = 46;

    public HaliteAttack() {
        super(Map.of(GMemoryModuleTypes.HALITE_ATTACK_COOLDOWN, class_4141.field_18457, class_4140.field_18441, class_4141.field_18456, GMemoryModuleTypes.IS_SMASHING, class_4141.field_18457, GMemoryModuleTypes.IS_IMPALING, class_4141.field_18457, GMemoryModuleTypes.IS_SUMMONING, class_4141.field_18457, GMemoryModuleTypes.IS_HALITE_ATTACKING, class_4141.field_18458), 46);
    }

    protected boolean checkExtraStartConditions(class_3218 serverLevel, Berserker livingEntity) {
        Iterator<class_1309> entities = this.getEntities(livingEntity);
        return livingEntity.shouldAttack() && livingEntity.method_41328(class_4050.field_18076) && entities != null && entities.hasNext();
    }

    protected boolean canStillUse(class_3218 serverLevel, Berserker livingEntity, long l) {
        livingEntity.method_18868().method_18875(class_4140.field_18445);
        livingEntity.method_18868().method_18875(class_4140.field_18446);
        return true;
    }

    protected void start(class_3218 serverLevel, Berserker livingEntity, long l) {
        Iterator<class_1309> entities = this.getEntities(livingEntity);
        if (entities == null || !entities.hasNext()) {
            return;
        }
        entities.forEachRemaining(living -> {
            HaliteCurse haliteCurse;
            class_243 vec3 = livingEntity.method_33571();
            class_243 vec32 = living.method_33571().method_1020(vec3);
            class_243 vec33 = vec32.method_1029();
            for (int i = 1; i < class_3532.method_15357((double)vec32.method_1033()) + 7; ++i) {
                class_243 vec34 = livingEntity.method_33571().method_1019(vec33.method_1021((double)i));
                serverLevel.method_14199((class_2394)class_2398.field_11205, vec34.field_1352, vec34.field_1351, vec34.field_1350, 30, 0.0, 0.0, 0.0, 0.0);
            }
            if (living instanceof HaliteCurse && !(haliteCurse = (HaliteCurse)living).shouldFreeze()) {
                living.method_6092(new class_1293(GMobEffects.HALITE_CURSE, 1200, 0, false, false));
            }
        });
        livingEntity.setPhase(Berserker.Phase.HALITE_ATTACK);
        livingEntity.method_5783(GSoundEvents.BERSERKER_HALITE_CURSE, 3.0f, 1.0f);
        livingEntity.method_18868().method_24525(GMemoryModuleTypes.IS_HALITE_ATTACKING, (Object)class_3902.field_17274, 46L);
    }

    @Nullable
    private Iterator<class_1309> getEntities(Berserker berserker) {
        Optional optional = berserker.method_18868().method_18904(class_4140.field_18442);
        return optional.map(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.method_38978(this::canAffectEntity).iterator()).orElse(null);
    }

    private boolean canAffectEntity(class_1309 living) {
        HaliteCurse haliteCurse;
        class_1321 tamableAnimal;
        if (!living.method_5805()) {
            return false;
        }
        boolean flag = living instanceof class_1321 && (tamableAnimal = (class_1321)living).method_35057() != null;
        boolean flag1 = living instanceof class_1427 && !(living instanceof class_1569);
        boolean flag2 = living instanceof HaliteCurse && (haliteCurse = (HaliteCurse)living).getHaliteTicks() == 0;
        return (flag || flag1) && flag2;
    }

    protected void stop(class_3218 serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
        livingEntity.method_18868().method_24525(GMemoryModuleTypes.HALITE_ATTACK_COOLDOWN, (Object)class_3902.field_17274, 100L);
    }
}

