/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.sparkle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.variants.SparkleVariant;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class WalkToPollinatedCluster
extends class_4097<Sparkle> {
    private int sniffingTicks;
    private int stuckTicks;
    private boolean setCooldownOnly = false;

    public WalkToPollinatedCluster() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER, (Object)class_4141.field_18456, GMemoryModuleTypes.POLLINATED_COOLDOWN, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(class_3218 world, Sparkle entity) {
        return !entity.method_6109() && this.getNearestCluster(entity).isPresent() && !entity.method_18868().method_18896(class_4140.field_18448) && !entity.method_18868().method_18896(class_4140.field_39408);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canStillUse(class_3218 world, Sparkle entity, long p_22547_) {
        if (this.stuckTicks > 200) {
            this.setCooldownOnly = true;
            return false;
        }
        if (this.sniffingTicks <= 0) return false;
        if (!this.getNearestCluster(entity).map(arg_0 -> ((class_3218)world).method_8320(arg_0)).filter(this::isPollinatedCluster).isPresent()) return false;
        return true;
    }

    private boolean isPollinatedCluster(class_2680 state) {
        return state.method_27852(class_2246.field_27161) || state.method_26204() instanceof PollinatedClusterBlock && (Boolean)state.method_11654((class_2769)PollinatedClusterBlock.POLLINATED) == false;
    }

    protected void start(class_3218 world, Sparkle entity, long p_22542_) {
        this.sniffingTicks = 100;
    }

    protected void tick(class_3218 p_22551_, Sparkle entity, long p_22553_) {
        this.getNearestCluster(entity).ifPresent(blockPos -> {
            boolean flag;
            boolean bl = flag = (float)entity.method_24515().method_19455((class_2382)blockPos) <= (entity.method_5799() ? 2.0f : 1.0f);
            if (flag) {
                entity.method_5942().method_6340();
                --this.sniffingTicks;
            } else {
                ++this.stuckTicks;
            }
            class_4215.method_24561((class_1309)entity, (class_2338)blockPos, (float)2.0f, (int)0);
        });
    }

    protected void stop(class_3218 world, Sparkle entity, long p_22550_) {
        this.getNearestCluster(entity).filter(blockPos -> this.isPollinatedCluster(world.method_8320(blockPos))).ifPresent(blockPos -> {
            if (!this.setCooldownOnly) {
                class_2680 state = world.method_8320(blockPos);
                SparkleVariant variant = (SparkleVariant)entity.getVariant().comp_349();
                Optional<class_2248> crystal = variant.crystal().filter(class_1747.class::isInstance).map(class_1747.class::cast).map(class_1747::method_7711);
                if (crystal.isPresent() && state.method_27852(crystal.get()) && variant.glinted().isPresent()) {
                    class_2248 placeState = variant.glinted().get();
                    world.method_8652(blockPos, placeState.method_34725(state), 2);
                    world.method_8396(null, blockPos, placeState.method_9564().method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
                    world.method_20290(2005, blockPos, 0);
                    entity.method_18868().method_18875(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER);
                }
            }
            entity.method_18868().method_24525(GMemoryModuleTypes.POLLINATED_COOLDOWN, (Object)class_3902.field_17274, 100L);
        });
        this.stuckTicks = 0;
        this.setCooldownOnly = false;
    }

    protected boolean method_18915(long p_22537_) {
        return false;
    }

    private Optional<class_2338> getNearestCluster(Sparkle entity) {
        return entity.method_18868().method_18904(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER);
    }
}

