/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.orcinus.galosphere.api.GoldenBreath;
import net.orcinus.galosphere.api.HaliteCurse;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.api.Translucent;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.items.SterlingArmorItem;
import net.orcinus.galosphere.items.components.SpectreBound;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements GoldenBreath,
SpectreBoundSpyglass,
HaliteCurse,
Translucent {
    @Unique
    private static final class_2940<Integer> GOLDEN_AIR_SUPPLY = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> USING_SPECTRE_BOUNDED_SPYGLASS = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Integer> HALITE_TICKS = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> IS_TRANSLUCENT = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13323);
    @Shadow
    protected class_1799 field_6277;

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Shadow
    protected abstract void method_6069();

    @Shadow
    protected abstract void method_58150();

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    private void G$defineSyncedData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(GOLDEN_AIR_SUPPLY, (Object)0);
        builder.method_56912(USING_SPECTRE_BOUNDED_SPYGLASS, (Object)false);
        builder.method_56912(HALITE_TICKS, (Object)0);
        builder.method_56912(IS_TRANSLUCENT, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    public void G$addAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        tag.method_10569("GoldenAirSupply", this.getGoldenAirSupply());
        tag.method_10569("HaliteTicks", this.getHaliteTicks());
        tag.method_10556("IsTranslucent", this.isTranslucent());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    public void G$readAdditionalSavaData(class_2487 tag, CallbackInfo ci) {
        this.setGoldenAirSupply(tag.method_10550("GoldenAirSupply"));
        this.setHaliteTicks(tag.method_10550("HaliteTicks"));
        this.setTranslucent(tag.method_10577("IsTranslucent"));
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void G$tick(CallbackInfo ci) {
        class_1657 player;
        class_1293 effect;
        class_1309 $this = (class_1309)this;
        if (SpectreBoundSpyglass.canUseSpectreBoundSpyglass(this.field_6277) && !$this.method_37908().field_9236) {
            class_1297 spectreBound = ((class_3218)$this.method_37908()).method_14190(((SpectreBound)this.field_6277.method_57824(GDataComponents.SPECTRE_BOUND)).uuid());
            Optional.ofNullable(spectreBound).filter(Spectre.class::isInstance).map(Spectre.class::cast).filter(class_1309::method_5805).ifPresent(spectre -> {
                if ($this instanceof class_1657) {
                    class_1657 player = (class_1657)$this;
                    if (spectre.getManipulatorUUID() != player.method_5667()) {
                        boolean withinDistance;
                        boolean bl = withinDistance = Math.sqrt(Math.pow(player.method_23317() - spectre.method_23317(), 2.0) + Math.pow(player.method_23321() - spectre.method_23321(), 2.0)) < 110.0;
                        if (withinDistance) {
                            spectre.setCamera(player);
                        }
                    }
                }
            });
        }
        if ((effect = this.method_6112(GMobEffects.HALITE_CURSE)) != null && !effect.method_48559() && this.getHaliteTicks() > 0) {
            this.setHaliteTicks(this.getHaliteTicks() - 1);
        }
        if ($this instanceof class_1657 && (player = (class_1657)$this).method_5805() && !player.method_7325()) {
            class_2338 blockPos2;
            class_238 aABB = player.method_5829();
            class_1937 level = player.method_37908();
            class_5819 random = player.method_59922();
            class_2338 blockPos = class_2338.method_49637((double)(aABB.field_1323 + 1.0E-7), (double)(aABB.field_1322 + 1.0E-7), (double)(aABB.field_1321 + 1.0E-7));
            if (level.method_22343(blockPos, blockPos2 = class_2338.method_49637((double)(aABB.field_1320 - 1.0E-7), (double)(aABB.field_1325 - 1.0E-7), (double)(aABB.field_1324 - 1.0E-7)))) {
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                    for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                        for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                            mutableBlockPos.method_10103(i, j, k);
                            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                            double y = player.method_23318();
                            double anchorHeight = (double)mutableBlockPos.method_10264() + 0.5;
                            if (!blockState.method_27852(GBlocks.BURROW_ANCHOR) || !(y < anchorHeight)) continue;
                            player.field_5960 = true;
                            player.method_18800(0.0, 0.05, 0.0);
                            int count = 0;
                            while ((float)count < player.method_17681() * player.method_17682() * 25.0f) {
                                double d = player.method_23317() + (double)class_3532.method_32750((class_5819)random, (float)-0.7f, (float)0.7f);
                                double f = player.method_23321() + (double)class_3532.method_32750((class_5819)random, (float)-0.7f, (float)0.7f);
                                $this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_37568.method_9564()), d, y, f, 0.0, 0.0, 0.0);
                                ++count;
                            }
                            player.method_5783(class_3417.field_37363, 1.0f, 0.9f);
                        }
                    }
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"decreaseAirSupply"}, cancellable=true)
    private void G$decreaseAirSupply(int i, CallbackInfoReturnable<Integer> cir) {
        if (this.getGoldenAirSupply() > 0) {
            cir.setReturnValue((Object)i);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isAlive()Z", shift=At.Shift.AFTER, ordinal=0)}, method={"baseTick"})
    private void G$baseTick(CallbackInfo ci) {
        class_1309 $this = (class_1309)this;
        if (this.getGoldenAirSupply() > 0) {
            this.setGoldenAirSupply(this.decreaseGoldenAirSupply($this, this.getGoldenAirSupply()));
        }
    }

    protected int decreaseGoldenAirSupply(class_1309 livingEntity, int i) {
        int reductionValue;
        class_1324 attributeInstance = livingEntity.method_5996(class_5134.field_51583);
        double d = attributeInstance != null ? attributeInstance.method_6194() : 0.0;
        int n = reductionValue = livingEntity.method_5777(class_3486.field_15517) ? 1 : 2;
        if (d > 0.0 && livingEntity.method_59922().method_43058() >= 1.0 / (d + 1.0)) {
            return i;
        }
        return Math.max(i - reductionValue, 0);
    }

    @Inject(at={@At(value="HEAD")}, method={"isInWall"}, cancellable=true)
    private void G$isInWall(CallbackInfoReturnable<Boolean> cir) {
        class_1309 $this = (class_1309)this;
        if ($this != null && $this.method_6059(GMobEffects.ASTRAL)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtArmor(Lnet/minecraft/world/damagesource/DamageSource;F)V", shift=At.Shift.AFTER)}, method={"getDamageAfterArmorAbsorb"}, cancellable=true)
    private void G$getDamageAfterArmorAbsorb(class_1282 damageSource, float f, CallbackInfoReturnable<Float> cir) {
        class_1308 mob;
        boolean flag;
        class_1309 $this = (class_1309)this;
        class_1304[] class_1304Array = damageSource.method_5529();
        boolean bl = flag = class_1304Array instanceof class_1308 && ((mob = (class_1308)class_1304Array).method_5864().method_20210(class_3483.field_48287) || mob.method_5864().method_20210(GEntityTypeTags.STERLING_IMMUNE_ENTITY_TYPES));
        if (flag) {
            class_1498 horse;
            if ($this instanceof class_1498 && (horse = (class_1498)$this).method_56676().method_31574(GItems.STERLING_HORSE_ARMOR)) {
                cir.setReturnValue((Object)Float.valueOf(f - 4.0f));
            }
            float illagerReduction = 0.0f;
            for (class_1304 equipmentSlot : class_1304.values()) {
                class_1792 class_17922 = $this.method_6118(equipmentSlot).method_7909();
                if (!(class_17922 instanceof SterlingArmorItem)) continue;
                SterlingArmorItem sterlingArmorItem = (SterlingArmorItem)class_17922;
                if (equipmentSlot.method_5925() != class_1304.class_1305.field_6178) continue;
                illagerReduction += SterlingArmorItem.getIllagerResistance(equipmentSlot);
            }
            if (illagerReduction > 0.0f) {
                float value = 4.0f * (f / illagerReduction);
                cir.setReturnValue((Object)Float.valueOf(value));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"removeEffectNoUpdate"})
    private void G$removeEffectNoUpdate(class_6880<class_1291> holder, CallbackInfoReturnable<class_1293> cir) {
        if (holder.method_55838(GMobEffects.HALITE_CURSE) && this.getHaliteTicks() > 0) {
            this.setHaliteTicks(0);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;updateGlowingStatus()V")}, method={"tickEffects"})
    private void G$tickEffects(CallbackInfo ci) {
        this.G$updateTranslucentStatus();
    }

    @Unique
    private void G$updateTranslucentStatus() {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity.method_6088().isEmpty()) {
            this.method_6069();
            this.setTranslucent(false);
        } else {
            this.setTranslucent(livingEntity.method_6059(GMobEffects.ASTRAL));
            this.method_58150();
        }
    }

    @Override
    public void setGoldenAirSupply(int goldenAirSupply) {
        ((class_1309)this).method_5841().method_12778(GOLDEN_AIR_SUPPLY, (Object)goldenAirSupply);
    }

    @Override
    public int getGoldenAirSupply() {
        return (Integer)((class_1309)this).method_5841().method_12789(GOLDEN_AIR_SUPPLY);
    }

    @Override
    public boolean isUsingSpectreBoundedSpyglass() {
        return (Boolean)((class_1309)this).method_5841().method_12789(USING_SPECTRE_BOUNDED_SPYGLASS);
    }

    @Override
    public void setUsingSpectreBoundedSpyglass(boolean usingSpectreBoundedSpyglass) {
        ((class_1309)this).method_5841().method_12778(USING_SPECTRE_BOUNDED_SPYGLASS, (Object)usingSpectreBoundedSpyglass);
    }

    @Override
    public int getHaliteTicks() {
        return (Integer)((class_1309)this).method_5841().method_12789(HALITE_TICKS);
    }

    @Override
    public void setHaliteTicks(int haliteTicks) {
        ((class_1309)this).method_5841().method_12778(HALITE_TICKS, (Object)haliteTicks);
    }

    @Override
    public boolean isTranslucent() {
        return (Boolean)((class_1309)this).method_5841().method_12789(IS_TRANSLUCENT);
    }

    @Override
    public void setTranslucent(boolean translucent) {
        ((class_1309)this).method_5841().method_12778(IS_TRANSLUCENT, (Object)translucent);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V")}, method={"onEquipItem"})
    private void G$onEquipItem(class_1304 equipmentSlot, class_1799 itemStack, class_1799 itemStack2, CallbackInfo ci) {
        boolean flag1;
        class_1498 horse;
        class_1309 $this = (class_1309)this;
        boolean flag = $this instanceof class_1498 && (horse = (class_1498)$this).method_35057() instanceof class_3222;
        boolean bl = flag1 = itemStack2.method_31574(GItems.STERLING_HORSE_ARMOR) && !((class_1799)itemStack2.method_57825(GDataComponents.STERLING_ATTACHED, (Object)class_1799.field_8037)).method_7960();
        if (flag && flag1) {
            GCriteriaTriggers.ATTACH_STERLING_HORSE.trigger((class_3222)((class_1498)$this).method_35057());
        }
    }
}

