/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6019;
import net.minecraft.class_7924;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.world.gen.FastNoise;
import net.orcinus.galosphere.world.gen.PinkSaltUtil;

public class OasisFeature
extends class_3031<class_3111> {
    public OasisFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_2338.class_2339 mutable3;
        class_5281 world = featurePlaceContext.method_33652();
        class_2338 blockPos = featurePlaceContext.method_33655();
        class_5819 random = featurePlaceContext.method_33654();
        int worldSeed = (int)world.method_8412();
        FastNoise fastNoise = new FastNoise(worldSeed);
        fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        fastNoise.SetFrequency(0.8f);
        int xRadius = this.getRandomRadius(random) / 2;
        int yRadius = class_6019.method_35017((int)15, (int)20).method_35008(random);
        int zRadius = this.getRandomRadius(random) / 2;
        ArrayList positions = Lists.newArrayList();
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                for (int y = -yRadius; y <= 0; ++y) {
                    int yThreshold;
                    boolean flag;
                    class_2338 pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z);
                    class_5138 structureManager = featurePlaceContext.method_33652().method_8410().method_27056();
                    class_3195 structure = (class_3195)structureManager.method_41036().method_30530(class_7924.field_41246).method_10223(Galosphere.id("pink_salt_shrine"));
                    boolean bl = flag = structure != null && structureManager.method_28388(blockPos, structure).method_16657();
                    if (flag) {
                        return false;
                    }
                    double xSquared = x * x;
                    double ySquared = y * y;
                    double zSquared = z * z;
                    double threshold = 1.0f + 3.0f * fastNoise.GetNoise(blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z);
                    int n = yThreshold = this.isDry() ? 2 : 0;
                    if (!(xSquared / (double)(xRadius * 2) + ySquared / (double)(yRadius * 2) + zSquared / (double)(zRadius * 2) < threshold) || !(xSquared + ySquared + zSquared <= (double)(xRadius * zRadius)) || y >= yThreshold) continue;
                    positions.add(pos);
                }
            }
        }
        int waterLevel = blockPos.method_10264() - 1;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (class_2338 position : positions) {
            mutable3 = mutableBlockPos.method_10103(position.method_10263(), Math.min(position.method_10264(), waterLevel), position.method_10260());
            for (int i = mutable3.method_10264(); i <= waterLevel; ++i) {
                this.generateMiniAquifer(world, (class_2338)mutable3, random);
                mutable3.method_10098(class_2350.field_11036);
            }
        }
        if (this.isDry()) {
            for (class_2338 position : positions) {
                mutable3 = mutableBlockPos.method_10103(position.method_10263(), Math.min(position.method_10264(), waterLevel), position.method_10260());
                for (int i = mutable3.method_10264(); i <= waterLevel; ++i) {
                    class_2680 mutableState = world.method_8320((class_2338)mutable3);
                    boolean flag = mutableState.method_26164(GBlockTags.PINK_SALT_BLOCKS);
                    boolean flag1 = flag && (world.method_8320(mutable3.method_10084()).method_26215() || world.method_8320(mutable3.method_10084()).method_26164(GBlockTags.PINK_SALT_BLOCKS));
                    boolean flag2 = mutableState.method_27852(class_2246.field_10382);
                    if (flag1 || flag2) {
                        world.method_8652((class_2338)mutable3, class_2246.field_10124.method_9564(), 2);
                        for (class_2350 direction : class_2350.values()) {
                            if (!world.method_8320(mutable3.method_10093(direction)).method_27852(class_2246.field_10382)) continue;
                            world.method_39281(mutable3.method_10093(direction), (class_3611)class_3612.field_15910, 0);
                        }
                    }
                    mutable3.method_10098(class_2350.field_11036);
                }
            }
        }
        return true;
    }

    private int getRandomRadius(class_5819 random) {
        return class_6019.method_35017((int)15, (int)21).method_35008(random);
    }

    private void generateMiniAquifer(class_5281 world, class_2338 mutable2, class_5819 randomSource) {
        if (world.method_8320(mutable2.method_10084()).method_26215()) {
            world.method_8652(mutable2, class_2246.field_10382.method_9564(), 2);
            world.method_39281(mutable2, (class_3611)class_3612.field_15910, 0);
        }
        class_2338.class_2339 mutable3 = new class_2338.class_2339();
        for (class_2350 value : class_2350.values()) {
            if (value == class_2350.field_11036) continue;
            mutable3.method_25505((class_2382)mutable2, value);
            if (world.method_8320((class_2338)mutable3).method_27852(class_2246.field_10382)) continue;
            world.method_8652((class_2338)mutable3, PinkSaltUtil.getBlock(world.method_8412(), mutable3).method_9564(), 2);
            this.postFeature(world, mutable3, randomSource);
        }
    }

    public boolean isDry() {
        return false;
    }

    public void postFeature(class_5281 world, class_2338.class_2339 mutableBlockPos, class_5819 randomSource) {
    }
}

