/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.api;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.orcinus.galosphere.client.tooltip.SterlingHelmetComponent;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.items.components.SterlingAttached;

public interface SterlingAttachable {
    default public boolean handleAttaching(ItemStack itemStack, ItemStack itemStack2, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!slot.allowModification(player)) {
            return false;
        }
        SterlingAttached component = (SterlingAttached)itemStack.get(GDataComponents.STERLING_ATTACHED.get());
        boolean flag = false;
        if (component == null) {
            return false;
        }
        ItemStack attached = component.attached();
        boolean emptyAttachment = attached.isEmpty();
        if (!emptyAttachment) {
            if (itemStack2.isEmpty() && clickAction == ClickAction.SECONDARY) {
                this.insert(itemStack, ItemStack.EMPTY, player);
            } else if (itemStack2.getItem() instanceof BannerItem && itemStack2.getCount() == 1) {
                this.insert(itemStack, itemStack2, player);
            } else {
                return false;
            }
            slotAccess.set(attached);
            flag = true;
        } else if (itemStack2.getItem() instanceof BannerItem) {
            this.insert(itemStack, itemStack2, player);
            flag = true;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (itemStack.is(GItems.STERLING_HELMET)) {
                    GCriteriaTriggers.ATTACH_STERLING.get().trigger(serverPlayer);
                }
            }
        }
        return flag;
    }

    default public void insert(ItemStack helmet, ItemStack mouseItem, Player player) {
        ItemStack copy;
        SoundEvent playSound = SoundEvents.BUNDLE_INSERT;
        if (mouseItem == ItemStack.EMPTY) {
            copy = ItemStack.EMPTY;
            playSound = SoundEvents.BUNDLE_REMOVE_ONE;
        } else {
            copy = mouseItem.copyWithCount(1);
            mouseItem.shrink(1);
        }
        helmet.set(GDataComponents.STERLING_ATTACHED.get(), (Object)SterlingAttached.attached(copy));
        player.playSound(playSound, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    default public Optional<TooltipComponent> getTooltip(ItemStack itemStack) {
        SterlingAttached sterlingAttached = (SterlingAttached)itemStack.get(GDataComponents.STERLING_ATTACHED.get());
        if (sterlingAttached == null) {
            return Optional.empty();
        }
        ItemStack attached = sterlingAttached.attached();
        return Optional.of(new SterlingHelmetComponent(attached));
    }
}

