/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GParticleTypes;
import org.jetbrains.annotations.Nullable;

public class PinkSaltStrawBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty FALLABLE = BooleanProperty.create((String)"fallable");
    public static final EnumProperty<StrawShape> STRAW_SHAPE = EnumProperty.create((String)"straw_shape", StrawShape.class);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape TOP_UP_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape TOP_DOWN_SHAPE = Block.box((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BOTTOM_UP_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape BOTTOM_DOWN_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Map<Predicate<BlockState>, SaltReaction> REACTIONS = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(blockState -> blockState.is(Blocks.COMPOSTER) && (Integer)blockState.getValue((Property)ComposterBlock.LEVEL) > 0, new SaltReaction(blockState -> ((Block)GBlocks.SALINE_COMPOSTER.get()).withPropertiesOf(blockState), 0.5f));
        map.put(blockState -> ((BiMap)WeatheringCopper.NEXT_BY_BLOCK.get()).containsKey((Object)blockState.getBlock()), new SaltReaction(blockState -> ((Block)WeatheringCopper.getNext((Block)blockState.getBlock()).orElseThrow()).withPropertiesOf(blockState), 0.0015f));
    });

    public PinkSaltStrawBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FALLABLE, (Comparable)Boolean.valueOf(false))).setValue(TIP_DIRECTION, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(STRAW_SHAPE, (Comparable)((Object)StrawShape.TOP)));
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockPos tip;
        this.maybeTransferFluid(blockState, serverLevel, blockPos, randomSource.nextFloat());
        if (serverLevel.getBlockState(blockPos.below(2)).is(Blocks.LAVA) && ((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue() && blockState.getValue(TIP_DIRECTION) == Direction.UP && (tip = this.findTip(blockState, (LevelAccessor)serverLevel, blockPos, 7)) != null && serverLevel.getFluidState(tip.above()).is(FluidTags.WATER)) {
            serverLevel.setBlockAndUpdate(tip.above(), (BlockState)((Block)GBlocks.PINK_SALT_STRAW.get()).defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }
    }

    private boolean isStalactiteStartPos(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return PinkSaltStrawBlock.isStalactite(blockState) && !levelReader.getBlockState(blockPos.above()).is((Block)GBlocks.PINK_SALT_STRAW.get());
    }

    public void maybeTransferFluid(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, float f) {
        BlockPos blockPos2 = this.findTip(blockState, (LevelAccessor)serverLevel, blockPos, 11);
        if (blockPos2 == null) {
            return;
        }
        if (!this.isStalactiteStartPos(blockState, (LevelReader)serverLevel, blockPos)) {
            return;
        }
        for (Predicate<BlockState> predicate : REACTIONS.keySet()) {
            BlockPos target = this.findTarget((Level)serverLevel, blockPos2, predicate);
            if (target == null) continue;
            SaltReaction saltReaction = REACTIONS.get(predicate);
            BlockState result = saltReaction.function.apply(serverLevel.getBlockState(target));
            if (f > saltReaction.chance()) {
                return;
            }
            serverLevel.levelEvent(3005, target, 0);
            serverLevel.setBlockAndUpdate(target, result);
        }
    }

    @Nullable
    private BlockPos findTip(BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos2, int i) {
        if (PinkSaltStrawBlock.isTip(blockState2)) {
            return blockPos2;
        }
        Direction direction = (Direction)blockState2.getValue(TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.is((Block)GBlocks.PINK_SALT_STRAW.get()) && blockState.getValue(TIP_DIRECTION) == direction;
        return this.findBlockVertical(levelAccessor, blockPos2, direction.getAxisDirection(), biPredicate, PinkSaltStrawBlock::isTip, i).orElse(null);
    }

    private static boolean isStalactite(BlockState state) {
        return state.is((Block)GBlocks.PINK_SALT_STRAW.get()) && state.getValue(TIP_DIRECTION) == Direction.DOWN;
    }

    @Nullable
    private BlockPos findTarget(Level level, BlockPos blockPos2, Predicate<BlockState> blockStatePredicate) {
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> this.canDripThrough((BlockGetter)level, (BlockPos)blockPos, (BlockState)blockState);
        return this.findBlockVertical((LevelAccessor)level, blockPos2, Direction.DOWN.getAxisDirection(), biPredicate, blockStatePredicate, 11).orElse(null);
    }

    private boolean canDripThrough(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        if (blockState.isAir()) {
            return true;
        }
        if (blockState.isSolidRender()) {
            return false;
        }
        if (!blockState.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelShape = blockState.getCollisionShape(blockGetter, blockPos);
        return !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.AND);
    }

    private Optional<BlockPos> findBlockVertical(LevelAccessor levelAccessor, BlockPos blockPos, Direction.AxisDirection axisDirection, BiPredicate<BlockPos, BlockState> biPredicate, Predicate<BlockState> predicate, int i) {
        Direction direction = Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable();
        for (int j = 1; j < i; ++j) {
            mutableBlockPos.move(direction);
            BlockState blockState = levelAccessor.getBlockState((BlockPos)mutableBlockPos);
            if (predicate.test(blockState)) {
                return Optional.of(mutableBlockPos.immutable());
            }
            if (!levelAccessor.isOutsideBuildHeight(mutableBlockPos.getY()) && biPredicate.test((BlockPos)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        int bound;
        int n = bound = (Boolean)blockState.getValue((Property)FALLABLE) != false ? 3 : 6;
        if (randomSource.nextInt(bound) == 0 && blockState.getValue(TIP_DIRECTION) == Direction.DOWN) {
            double d = (double)blockPos.getX() + randomSource.nextDouble();
            double e = (double)blockPos.getY() - 0.05;
            double f = (double)blockPos.getZ() + randomSource.nextDouble();
            level.addParticle((ParticleOptions)GParticleTypes.PINK_SALT_FALLING_DUST.get(), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, STRAW_SHAPE, TIP_DIRECTION, FALLABLE});
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos pos = blockHitResult.getBlockPos();
        double length = projectile.getDeltaMovement().length();
        if (length <= (double)0.4f) {
            return;
        }
        int steps = Mth.nextInt((RandomSource)level.getRandom(), (int)20, (int)30) * Mth.ceil((double)length);
        for (int i = 0; i < steps; ++i) {
            boolean flag;
            int radius = 3;
            if (level.getRandom().nextInt(5) == 0) {
                radius *= 2;
            }
            mutableBlockPos.set(pos.getX() + Mth.nextInt((RandomSource)level.getRandom(), (int)(-radius), (int)radius), pos.getY() + Mth.nextInt((RandomSource)level.getRandom(), (int)-2, (int)2), pos.getZ() + Mth.nextInt((RandomSource)level.getRandom(), (int)(-radius), (int)radius));
            BlockState chosenStates = level.getBlockState((BlockPos)mutableBlockPos);
            boolean bl = flag = chosenStates.is((Block)this) && chosenStates.getValue(TIP_DIRECTION) == Direction.DOWN && chosenStates.getValue(STRAW_SHAPE) == StrawShape.BOTTOM;
            if (!flag) continue;
            level.setBlockAndUpdate((BlockPos)mutableBlockPos, (BlockState)chosenStates.getBlock().withPropertiesOf(chosenStates).setValue((Property)FALLABLE, (Comparable)Boolean.valueOf(true)));
            double distance = Math.sqrt(projectile.distanceToSqr((double)mutableBlockPos.getX(), (double)mutableBlockPos.getY(), (double)mutableBlockPos.getZ()));
            int ticks = Math.max(1, (int)distance);
            level.scheduleTick((BlockPos)mutableBlockPos, (Block)this, ticks);
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos2, BlockState state2, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            access.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction direction2 = (Direction)state.getValue(TIP_DIRECTION);
        if (direction2 == Direction.DOWN && access.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (direction == direction2.getOpposite() && !this.canSurvive(state, level, pos)) {
            access.scheduleTick(pos, (Block)this, 1);
        }
        StrawShape pinkSaltStrawShape = PinkSaltStrawBlock.calculateStrawShape(level, pos, direction2);
        return (BlockState)state.setValue(STRAW_SHAPE, (Comparable)((Object)pinkSaltStrawShape));
    }

    private static StrawShape calculateStrawShape(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        Direction oppositeDirection = direction.getOpposite();
        BlockState blockState = levelReader.getBlockState(blockPos.relative(direction));
        BlockState oppositeState = levelReader.getBlockState(blockPos.relative(oppositeDirection));
        if (!blockState.is((Block)GBlocks.PINK_SALT_STRAW.get())) {
            return StrawShape.TOP;
        }
        if (!oppositeState.is((Block)GBlocks.PINK_SALT_STRAW.get())) {
            return StrawShape.BOTTOM;
        }
        return StrawShape.MIDDLE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.getNearestLookingVerticalDirection().getOpposite();
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        Level levelAccessor = blockPlaceContext.getLevel();
        Direction direction2 = PinkSaltStrawBlock.calculateTipDirection((LevelReader)levelAccessor, blockPos, direction);
        if (direction2 == null) {
            return null;
        }
        StrawShape pinkSaltStrawShape = PinkSaltStrawBlock.calculateStrawShape((LevelReader)levelAccessor, blockPos, direction2);
        if (pinkSaltStrawShape == null) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TIP_DIRECTION, (Comparable)direction2)).setValue(STRAW_SHAPE, (Comparable)((Object)pinkSaltStrawShape))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.getFluidState(blockPos).getType() == Fluids.WATER));
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        Direction direction2;
        if (PinkSaltStrawBlock.isValidPinkSaltStraw(levelReader, blockPos, direction)) {
            direction2 = direction;
        } else if (PinkSaltStrawBlock.isValidPinkSaltStraw(levelReader, blockPos, direction.getOpposite())) {
            direction2 = direction.getOpposite();
        } else {
            return null;
        }
        return direction2;
    }

    private static boolean isValidPinkSaltStraw(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.relative(direction.getOpposite());
        BlockState blockState = levelReader.getBlockState(blockPos2);
        return blockState.isFaceSturdy((BlockGetter)levelReader, blockPos2, direction) || PinkSaltStrawBlock.isPinkSaltStrawWithDirection(blockState, direction);
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return PinkSaltStrawBlock.isValidPinkSaltStrawPlacement(levelReader, blockPos, (Direction)blockState.getValue(TIP_DIRECTION));
    }

    private static boolean isValidPinkSaltStrawPlacement(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.relative(direction.getOpposite());
        BlockState blockState = levelReader.getBlockState(blockPos2);
        return blockState.isFaceSturdy((BlockGetter)levelReader, blockPos2, direction) || PinkSaltStrawBlock.isPinkSaltStrawWithDirection(blockState, direction);
    }

    private static boolean isPinkSaltStrawWithDirection(BlockState blockState, Direction direction) {
        return blockState.is((Block)GBlocks.PINK_SALT_STRAW.get()) && blockState.getValue(TIP_DIRECTION) == direction;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        boolean up;
        Vec3 vec3 = blockState.getOffset(blockPos);
        StrawShape value = (StrawShape)((Object)blockState.getValue(STRAW_SHAPE));
        boolean bl = up = blockState.getValue(TIP_DIRECTION) == Direction.UP;
        VoxelShape voxelShape = value == StrawShape.TOP ? (up ? TOP_UP_SHAPE : TOP_DOWN_SHAPE) : (value == StrawShape.BOTTOM ? (up ? BOTTOM_UP_SHAPE : BOTTOM_DOWN_SHAPE) : MIDDLE_SHAPE);
        return voxelShape.move(vec3.x, 0.0, vec3.z);
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)FALLABLE)).booleanValue()) {
            BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable();
            BlockState blockState2 = blockState;
            while (blockState2.is((Block)GBlocks.PINK_SALT_STRAW.get()) && blockState2.getValue(TIP_DIRECTION) == Direction.DOWN) {
                FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)serverLevel, (BlockPos)mutableBlockPos, (BlockState)blockState2);
                if (PinkSaltStrawBlock.isTip(blockState2)) {
                    int i = Math.max(1 + blockPos.getY() - mutableBlockPos.getY(), 6);
                    float f = i;
                    fallingBlockEntity.setHurtsEntities(f, 40);
                    break;
                }
                mutableBlockPos.move(Direction.DOWN);
                blockState2 = serverLevel.getBlockState((BlockPos)mutableBlockPos);
            }
        }
        if (!blockState.canSurvive((LevelReader)serverLevel, blockPos)) {
            serverLevel.destroyBlock(blockPos, true);
        }
    }

    private static boolean isTip(BlockState blockState) {
        if (!blockState.is((Block)GBlocks.PINK_SALT_STRAW.get())) {
            return false;
        }
        return blockState.getValue(STRAW_SHAPE) == StrawShape.TOP;
    }

    public static enum StrawShape implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private StrawShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    record SaltReaction(Function<BlockState, BlockState> function, float chance) {
    }
}

