/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import org.jetbrains.annotations.Nullable;

public class SoilComposterBlock
extends ComposterBlock {
    public SoilComposterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return new ItemStack((ItemLike)Items.COMPOSTER);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if ((Integer)blockState.getValue((Property)LEVEL) == 8) {
            SoilComposterBlock.extractGlowstoneDust(blockState, level, blockPos);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                GCriteriaTriggers.COMPOST_RETRIEVAL.get().trigger(serverPlayer, blockState);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    public static BlockState extractGlowstoneDust(BlockState state, Level world, BlockPos pos) {
        if (!world.isClientSide) {
            double d0 = (double)(world.random.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(world.random.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(world.random.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity itementity = new ItemEntity(world, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, new ItemStack((ItemLike)Items.COARSE_DIRT));
            itementity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itementity);
        }
        BlockState blockstate = SoilComposterBlock.empty(state, (LevelAccessor)world, pos);
        world.playSound(null, pos, SoundEvents.COMPOSTER_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        return blockstate;
    }

    public static BlockState empty(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState blockstate = (BlockState)Blocks.COMPOSTER.defaultBlockState().setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(0));
        world.setBlock(pos, blockstate, 3);
        return blockstate;
    }

    public static BlockState addItem(BlockState state, LevelAccessor world, BlockPos pos, ItemStack stack) {
        int i = (Integer)state.getValue((Property)LEVEL);
        float f = COMPOSTABLES.getFloat((Object)stack.getItem());
        if (!(i == 0 && f > 0.0f || world.getRandom().nextDouble() < (double)f)) {
            return state;
        }
        int j = i + 1;
        BlockState blockstate = (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(j));
        world.setBlock(pos, blockstate, 3);
        if (j == 7) {
            world.scheduleTick(pos, state.getBlock(), 20);
        }
        return blockstate;
    }

    public WorldlyContainer getContainer(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        int i = (Integer)blockState.getValue((Property)LEVEL);
        if (i == 8) {
            return new OutputContainer(blockState, levelAccessor, blockPos, new ItemStack((ItemLike)Items.COARSE_DIRT));
        }
        if (i < 7) {
            return new InputContainer(blockState, levelAccessor, blockPos);
        }
        return new EmptyContainer();
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public OutputContainer(BlockState state, LevelAccessor world, BlockPos pos, ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.level = world;
            this.pos = pos;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int[] getSlotsForFace(Direction direction) {
            int[] nArray = direction == Direction.DOWN ? new int[1] : new int[]{};
            return nArray;
        }

        public boolean canPlaceItemThroughFace(int p_52049_, ItemStack p_52050_, @Nullable Direction p_52051_) {
            return false;
        }

        public boolean canTakeItemThroughFace(int p_52055_, ItemStack p_52056_, Direction direection) {
            return !this.changed && direection == Direction.DOWN && p_52056_.is(Items.COARSE_DIRT);
        }

        public void setChanged() {
            SoilComposterBlock.empty(this.state, this.level, this.pos);
            this.changed = true;
        }
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public InputContainer(BlockState p_52022_, LevelAccessor p_52023_, BlockPos p_52024_) {
            super(1);
            this.state = p_52022_;
            this.level = p_52023_;
            this.pos = p_52024_;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int[] getSlotsForFace(Direction direction) {
            int[] nArray = direction == Direction.UP ? new int[1] : new int[]{};
            return nArray;
        }

        public boolean canPlaceItemThroughFace(int p_52028_, ItemStack p_52029_, @Nullable Direction p_52030_) {
            return !this.changed && p_52030_ == Direction.UP && ComposterBlock.COMPOSTABLES.containsKey((Object)p_52029_.getItem());
        }

        public boolean canTakeItemThroughFace(int p_52034_, ItemStack p_52035_, Direction p_52036_) {
            return false;
        }

        public void setChanged() {
            ItemStack itemstack = this.getItem(0);
            if (!itemstack.isEmpty()) {
                this.changed = true;
                BlockState blockstate = SoilComposterBlock.addItem(this.state, this.level, this.pos, itemstack);
                this.level.levelEvent(1500, this.pos, blockstate != this.state ? 1 : 0);
                this.removeItemNoUpdate(0);
            }
        }
    }

    static class EmptyContainer
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyContainer() {
            super(0);
        }

        public int[] getSlotsForFace(Direction direction) {
            return new int[0];
        }

        public boolean canPlaceItemThroughFace(int p_52008_, ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean canTakeItemThroughFace(int p_52014_, ItemStack stack, Direction direction) {
            return false;
        }
    }
}

