/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class BurrowAnchorBlockEntity
extends BlockEntity {
    @Nullable
    private BlockPos teleportPos;
    private int cooldown = 0;

    public BurrowAnchorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(GBlockEntityTypes.BURROW_ANCHOR.get(), blockPos, blockState);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.getTeleportPos() != null) {
            compoundTag.storeNullable("TeleportPos", BlockPos.CODEC, (Object)this.getTeleportPos());
        }
        compoundTag.putInt("Cooldown", this.cooldown);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.setTeleportPos(compoundTag.read("TeleportPos", BlockPos.CODEC).orElse(null));
        this.cooldown = compoundTag.getIntOr("Cooldown", 0);
    }

    @Nullable
    public BlockPos getTeleportPos() {
        return this.teleportPos;
    }

    public void setTeleportPos(BlockPos teleportPos) {
        this.teleportPos = teleportPos;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BurrowAnchorBlockEntity burrowAnchorBlockEntity) {
        int cooldown = burrowAnchorBlockEntity.getCooldown();
        if (cooldown > 0) {
            burrowAnchorBlockEntity.setCooldown(cooldown - 1);
        }
    }
}

