/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.blocks.GlowInkClumpsBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.network.SendParticlesPacket;

public class GlowInkClumpsBlockEntity
extends BlockEntity {
    private static int delay;

    public GlowInkClumpsBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntityTypes.GLOW_INK_CLUMPS.get(), pos, state);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, GlowInkClumpsBlockEntity te) {
        if ((Integer)state.getValue((Property)BlockStateProperties.AGE_15) == 0) {
            return;
        }
        if (delay > 0) {
            --delay;
        } else {
            GlowInkClumpsBlockEntity.generateGlowInk(world, pos, state, 2);
        }
    }

    private static void generateGlowInk(Level world, BlockPos pos, BlockState originState, int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -range; y <= range; ++y) {
                    BlockPos offset = pos.offset(x, y, z);
                    if (!world.getBlockState(offset).isCollisionShapeFullBlock((BlockGetter)world, offset) || x * x + z * z + y * y > range * range) continue;
                    for (Direction direction : Direction.values()) {
                        BlockPos relative = offset.relative(direction.getOpposite());
                        BlockState state = world.getBlockState(relative);
                        BlockState placeState = (BlockState)((BlockState)((Block)GBlocks.GLOW_INK_CLUMPS.get()).defaultBlockState().setValue((Property)GlowInkClumpsBlock.getFaceProperty((Direction)direction), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NATURAL, (Comparable)Boolean.valueOf(false));
                        world.setBlock(pos, (BlockState)((BlockState)originState.setValue((Property)BlockStateProperties.NATURAL, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(Math.max(0, (Integer)originState.getValue((Property)BlockStateProperties.AGE_15) - ((Integer)originState.getValue((Property)BlockStateProperties.AGE_15) <= 4 ? 3 : 1)))), 2);
                        if (!world.isStateAtPosition(relative, DripstoneUtils::isEmptyOrWater) && (!world.getBlockState(relative).canBeReplaced() || world.getFluidState(relative).is(FluidTags.LAVA)) || state.getBlock() instanceof GlowInkClumpsBlock && ((Boolean)state.getValue((Property)GlowInkClumpsBlock.getFaceProperty((Direction)direction))).booleanValue()) continue;
                        for (Direction dir : Direction.values()) {
                            if (!world.getBlockState(relative.relative(dir)).isCollisionShapeFullBlock((BlockGetter)world, relative.relative(dir))) continue;
                            placeState = (BlockState)placeState.setValue((Property)GlowInkClumpsBlock.getFaceProperty((Direction)dir), (Comparable)Boolean.valueOf(true));
                        }
                        if (delay != 0) continue;
                        if (world instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)world;
                            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)offset.getX(), (double)offset.getY(), (double)offset.getZ(), (double)16.0, (CustomPacketPayload)new SendParticlesPacket(offset), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        int age = 0;
                        if (x == 1 || x == -1 && z == 1 || z == -1) {
                            age = Math.max(0, (Integer)originState.getValue((Property)BlockStateProperties.AGE_15) - 3);
                        }
                        world.setBlock(relative, (BlockState)((BlockState)placeState.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(age))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getBlockState(relative).is(Blocks.WATER))), 2);
                        delay = 2;
                    }
                }
            }
        }
    }

    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider provider) {
        super.loadAdditional(valueInput, provider);
        delay = valueInput.getIntOr("delay", 0);
    }

    protected void saveAdditional(CompoundTag valueInput, HolderLookup.Provider provider) {
        super.saveAdditional(valueInput, provider);
        valueInput.putInt("delay", delay);
    }
}

