/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.ShadowFrameBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class ShadowFrameBlockEntity
extends BlockEntity {
    private boolean isWaxed;
    private BlockState copiedState = Blocks.AIR.defaultBlockState();

    public ShadowFrameBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(GBlockEntityTypes.SHADOW_FRAME.get(), blockPos, blockState);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        RegistryOps registryOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.copiedState = compoundTag.read("CopiedState", BlockState.CODEC, (DynamicOps)registryOps).orElse(Blocks.AIR.defaultBlockState());
        this.isWaxed = compoundTag.getBooleanOr("is_waxed", false);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        RegistryOps registryOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        compoundTag.store("CopiedState", BlockState.CODEC, (DynamicOps)registryOps, (Object)this.getCopiedState());
        compoundTag.putBoolean("is_waxed", this.isWaxed);
    }

    public BlockState getCopiedState() {
        return this.copiedState;
    }

    public void setCopiedState(BlockState copiedState) {
        this.copiedState = copiedState;
    }

    public void interact(BlockState copiedState, Level level, BlockPos blockPos, BlockState blockState) {
        this.setCopiedState(copiedState);
        int light = 0;
        if (copiedState.getLightEmission() > 0) {
            light = Math.min(15, copiedState.getLightEmission());
        }
        level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)ShadowFrameBlock.FILLED, (Comparable)Boolean.valueOf(true))).setValue((Property)ShadowFrameBlock.LEVEL, (Comparable)Integer.valueOf(light)), 2);
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

