/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.gui;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.orcinus.galosphere.Galosphere;

@OnlyIn(value=Dist.CLIENT)
public class GoldenBreathOverlay {
    private static final ResourceLocation GOLDEN_AIR_SPRITE = Galosphere.id("hud/golden_air");
    private static final ResourceLocation GOLDEN_AIR_POPPING_SPRITE = Galosphere.id("hud/golden_air_bursting");
    public static int airSupply = 0;

    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Player player1;
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (!mc.options.hideGui && mc.gameMode != null && mc.gameMode.canHurtPlayer() && (entity = mc.getCameraEntity()) instanceof Player && (player1 = (Player)entity).isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            GoldenBreathOverlay.renderGoldenAirSupply(guiGraphics, player1, mc.gui);
        }
    }

    private static void renderGoldenAirSupply(GuiGraphics guiGraphics, Player player, Gui gui) {
        int supply = airSupply;
        int l = 300;
        int m = Math.clamp((long)supply, 0, l);
        int k = guiGraphics.guiWidth() / 2 + 91;
        int height = guiGraphics.guiHeight() - 39;
        int j = height - 20;
        boolean bl = player.isEyeInFluid(FluidTags.WATER);
        int t = gui.getVehicleMaxHearts((LivingEntity)player);
        if (bl || m < l) {
            boolean bl2;
            j = gui.getAirBubbleYLine(t, j);
            int n = GoldenBreathOverlay.getCurrentAirSupplyBubble(m, l, -2);
            int o = GoldenBreathOverlay.getCurrentAirSupplyBubble(m, l, 0);
            int p = 4 - GoldenBreathOverlay.getCurrentAirSupplyBubble(m, l, GoldenBreathOverlay.getEmptyBubbleDelayDuration(m, bl));
            boolean bl3 = bl2 = n != o;
            if (!bl) {
                gui.lastBubblePopSoundPlayed = 0;
            }
            for (int count = 1; count <= 4; ++count) {
                int r = k - (count - 1) * 8 - 9;
                if (count <= n) {
                    guiGraphics.blitSprite(RenderType::guiTextured, GOLDEN_AIR_SPRITE, r, j, 9, 9);
                    continue;
                }
                if (!bl2 || count != o || !bl) continue;
                guiGraphics.blitSprite(RenderType::guiTextured, GOLDEN_AIR_POPPING_SPRITE, r, j, 9, 9);
                gui.playAirBubblePoppedSound(count, player, p);
            }
        }
    }

    private static int getCurrentAirSupplyBubble(int i, int j, int k) {
        return Mth.ceil((float)((float)((i + k) * 4) / (float)j));
    }

    private static int getEmptyBubbleDelayDuration(int i, boolean bl) {
        return i != 0 && bl ? 1 : 0;
    }
}

