/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RopeDartModel
extends EntityModel<ArrowRenderState> {
    public RopeDartModel(ModelPart root) {
        super(root, RenderType::entityCutout);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -2.0f, 0.0f, 16.0f, 4.0f, 0.0f, CubeDeformation.NONE, 1.0f, 0.8f);
        partdefinition.addOrReplaceChild("cross_1", cubeListBuilder, PartPose.rotation((float)0.7853982f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("cross_2", cubeListBuilder, PartPose.rotation((float)2.3561945f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition.transformed(partPose -> partPose.scaled(0.9f)), (int)32, (int)32);
    }

    public void setupAnim(ArrowRenderState arrowRenderState) {
        super.setupAnim((EntityRenderState)arrowRenderState);
        if (arrowRenderState.shake > 0.0f) {
            float f = -Mth.sin((float)(arrowRenderState.shake * 3.0f)) * arrowRenderState.shake;
            this.root.zRot += f * ((float)Math.PI / 180);
        }
    }
}

