/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.renderer.entity.state.SparkleRenderState;

@OnlyIn(value=Dist.CLIENT)
public class SparkleModel
extends EntityModel<SparkleRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.5f);
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart head;

    public SparkleModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
        this.rightArm = root.getChild("rightArm");
        this.leftArm = root.getChild("leftArm");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.0f, -4.0f, 5.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)1.0f));
        PartDefinition crystal1 = tail.addOrReplaceChild("crystal1", CubeListBuilder.create().texOffs(24, 4).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition crystal2 = tail.addOrReplaceChild("crystal2", CubeListBuilder.create().texOffs(24, 4).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)2.3562f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(-3, 5).addBox(0.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)22.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(-3, 5).mirror().addBox(-5.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)22.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(-3, 5).mirror().addBox(-5.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)22.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(-3, 5).addBox(0.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)22.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -2.0f, -6.0f, 6.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(21, 5).addBox(1.0f, -2.0f, 1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(21, 5).mirror().addBox(-3.0f, -2.0f, 1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)-5.0f));
        PartDefinition beard = head.addOrReplaceChild("beard", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-3.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftWhisker = head.addOrReplaceChild("leftWhisker", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.5f, (float)-6.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition rightWhisker = head.addOrReplaceChild("rightWhisker", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -0.5f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)0.5f, (float)-6.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public void setupAnim(SparkleRenderState sparkleRenderState) {
        float limbSwing = sparkleRenderState.walkAnimationPos;
        float limbSwingAmount = sparkleRenderState.walkAnimationSpeed;
        float ageInTicks = sparkleRenderState.ageInTicks;
        float i = sparkleRenderState.movingFactor;
        float g = sparkleRenderState.inWaterFactor;
        float threshold = Math.min(i, g);
        if (!(threshold <= 1.0E-5f)) {
            this.body.yRot = Mth.cos((float)(ageInTicks / 2.0f)) / 8.0f;
            this.tail.yRot = Mth.sin((float)(ageInTicks / 2.0f)) / 3.5f;
        } else {
            this.body.yRot = 0.0f;
            this.leftLeg.xRot = Mth.sin((float)limbSwing) * limbSwingAmount;
            this.leftLeg.yRot = Mth.cos((float)limbSwing) * limbSwingAmount * 2.0f;
            this.rightLeg.xRot = -Mth.sin((float)(limbSwing * 1.5f)) * limbSwingAmount;
            this.rightLeg.yRot = Mth.cos((float)(limbSwing * 1.5f)) * limbSwingAmount * 2.0f;
            this.leftArm.xRot = -Mth.sin((float)(limbSwing * 1.5f)) * limbSwingAmount;
            this.leftArm.yRot = Mth.cos((float)(limbSwing * 1.5f)) * limbSwingAmount * 2.0f;
            this.rightArm.xRot = Mth.sin((float)limbSwing) * limbSwingAmount;
            this.rightArm.yRot = Mth.cos((float)limbSwing) * limbSwingAmount * 2.0f;
            this.tail.yRot = Mth.cos((float)(limbSwing * 1.0f * 2.0f)) * limbSwingAmount;
            this.head.yRot = sparkleRenderState.yRot * ((float)Math.PI / 180);
            this.head.xRot = sparkleRenderState.xRot * ((float)Math.PI / 180);
        }
    }
}

