/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.blocks.GildedBeadsBlock;
import net.orcinus.galosphere.blocks.blockentities.GildedBeadsBlockEntity;
import net.orcinus.galosphere.init.GModelLayers;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class GildedBeadsRenderer
implements BlockEntityRenderer<GildedBeadsBlockEntity> {
    public static final Function<BlockState, Material> FUNCTION = state -> new Material(TextureAtlas.LOCATION_BLOCKS, Galosphere.id("entity/gilded_beads/" + ((Boolean)state.getValue((Property)BlockStateProperties.BOTTOM) != false ? "gilded_beads_head" : "gilded_beads_body")));
    private final ModelPart gilded_beads;

    public GildedBeadsRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(GModelLayers.GILDED_BEADS);
        this.gilded_beads = modelPart.getChild("gilded_beads");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("gilded_beads", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -16.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(GildedBeadsBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, Vec3 vec3) {
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-RotationSegment.convertToDegrees((int)((Integer)blockEntity.getBlockState().getValue((Property)GildedBeadsBlock.ROTATION)))));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        VertexConsumer vertexConsumer = FUNCTION.apply(blockEntity.getBlockState()).buffer(multiBufferSource, RenderType::entityCutoutNoCull);
        this.gilded_beads.render(poseStack, vertexConsumer, i, j);
        poseStack.popPose();
    }
}

