/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.blocks.ShadowFrameBlock;
import net.orcinus.galosphere.blocks.blockentities.ShadowFrameBlockEntity;
import net.orcinus.galosphere.init.GBlocks;

@OnlyIn(value=Dist.CLIENT)
public class ShadowFrameBlockRenderer
implements BlockEntityRenderer<ShadowFrameBlockEntity> {
    static final Direction[] DIRECTIONS = Direction.values();
    private final BlockRenderDispatcher blockRenderer;

    public ShadowFrameBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(ShadowFrameBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, Vec3 vec3) {
        BlockState state = blockEntity.getCopiedState();
        if (state == null || state.isAir()) {
            return;
        }
        List list = this.blockRenderer.getBlockModel(state).collectParts(RandomSource.create((long)state.getSeed(blockEntity.getBlockPos())));
        if (blockEntity.getLevel() != null) {
            this.tesselateBlock((BlockAndTintGetter)blockEntity.getLevel(), list, state, blockEntity.getBlockPos(), poseStack, multiBufferSource.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)state)), false, 0L, OverlayTexture.NO_OVERLAY);
        }
    }

    public void tesselateBlock(BlockAndTintGetter blockAndTintGetter, List<BlockModelPart> list, BlockState blockState, BlockPos blockPos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean bl, long l, int i) {
        if (!list.isEmpty()) {
            boolean bl2 = Minecraft.useAmbientOcclusion() && blockState.getLightEmission() == 0 && list.get(0).useAmbientOcclusion();
            poseStack.translate(blockState.getOffset(blockPos));
            try {
                if (bl2) {
                    this.tesselateWithAO(blockAndTintGetter, list, blockState, blockPos, poseStack, vertexConsumer, bl, i);
                } else {
                    this.tesselateWithoutAO(blockAndTintGetter, list, blockState, blockPos, poseStack, vertexConsumer, bl, i);
                }
            }
            catch (Throwable var13) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)var13, (String)"Tesselating block model");
                CrashReportCategory crashReportCategory = crashReport.addCategory("Block model being tesselated");
                CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)blockAndTintGetter, (BlockPos)blockPos, (BlockState)blockState);
                crashReportCategory.setDetail("Using AO", (Object)bl2);
                throw new ReportedException(crashReport);
            }
        }
    }

    public void tesselateWithAO(BlockAndTintGetter blockAndTintGetter, List<BlockModelPart> bakedModel, BlockState blockState, BlockPos blockPos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean bl, int i) {
        ModelBlockRenderer.AmbientOcclusionRenderStorage ambientOcclusionRenderStorage = new ModelBlockRenderer.AmbientOcclusionRenderStorage();
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable();
        for (BlockModelPart blockModelPart : bakedModel) {
            for (Direction direction : DIRECTIONS) {
                List list = blockModelPart.getQuads(direction);
                if (list.isEmpty()) continue;
                mutableBlockPos.setWithOffset((Vec3i)blockPos, direction);
                if (this.skipRendering(blockAndTintGetter, blockState, blockPos, bl, mutableBlockPos, direction)) continue;
                this.renderModelFaceAO(blockAndTintGetter, blockState, blockPos, poseStack, vertexConsumer, list, ambientOcclusionRenderStorage, i);
            }
            List list2 = blockModelPart.getQuads(null);
            if (list2.isEmpty()) continue;
            this.renderModelFaceAO(blockAndTintGetter, blockState, blockPos, poseStack, vertexConsumer, list2, ambientOcclusionRenderStorage, i);
        }
    }

    public void tesselateWithoutAO(BlockAndTintGetter blockAndTintGetter, List<BlockModelPart> parts, BlockState blockState, BlockPos blockPos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean bl, int i) {
        ModelBlockRenderer.CommonRenderStorage commonRenderStorage = new ModelBlockRenderer.CommonRenderStorage();
        for (BlockModelPart blockModelPart : parts) {
            for (Direction direction : DIRECTIONS) {
                BlockPos.MutableBlockPos blockPos2;
                List list = blockModelPart.getQuads(direction);
                if (list.isEmpty() || this.skipRendering(blockAndTintGetter, blockState, blockPos, bl, (blockPos2 = commonRenderStorage.scratchPos.setWithOffset((Vec3i)blockPos, direction)).mutable(), direction)) continue;
                int j = commonRenderStorage.cache.getLightColor(blockState, blockAndTintGetter, (BlockPos)blockPos2);
                this.renderModelFaceFlat(blockAndTintGetter, blockState, blockPos, j, i, false, poseStack, vertexConsumer, list, commonRenderStorage);
            }
            List list2 = blockModelPart.getQuads(null);
            if (list2.isEmpty()) continue;
            this.renderModelFaceFlat(blockAndTintGetter, blockState, blockPos, -1, i, true, poseStack, vertexConsumer, list2, commonRenderStorage);
        }
    }

    private boolean skipRendering(BlockAndTintGetter blockAndTintGetter, BlockState blockState, BlockPos blockPos, boolean bl, BlockPos.MutableBlockPos mutableBlockPos, Direction direction) {
        BlockState relativeState = blockAndTintGetter.getBlockState((BlockPos)mutableBlockPos);
        if (relativeState.is((Block)GBlocks.SHADOW_FRAME.get()) && ((Boolean)relativeState.getValue((Property)ShadowFrameBlock.FILLED)).booleanValue()) {
            BlockEntity blockEntity = blockAndTintGetter.getBlockEntity((BlockPos)mutableBlockPos);
            if (blockEntity instanceof ShadowFrameBlockEntity) {
                ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
                return shadowFrameBlockEntity.getCopiedState().isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, (BlockPos)mutableBlockPos);
            }
            return true;
        }
        return bl && !Block.shouldRenderFace((BlockState)blockState, (BlockState)blockAndTintGetter.getBlockState((BlockPos)mutableBlockPos), (Direction)direction);
    }

    private void renderModelFaceAO(BlockAndTintGetter blockAndTintGetter, BlockState blockState, BlockPos blockPos, PoseStack poseStack, VertexConsumer vertexConsumer, List<BakedQuad> list, ModelBlockRenderer.AmbientOcclusionRenderStorage ambientOcclusionRenderStorage, int i) {
        for (BakedQuad bakedQuad : list) {
            this.calculateShape(blockAndTintGetter, blockState, blockPos, bakedQuad.vertices(), bakedQuad.direction(), (ModelBlockRenderer.CommonRenderStorage)ambientOcclusionRenderStorage);
            ambientOcclusionRenderStorage.calculate(blockAndTintGetter, blockState, blockPos, bakedQuad.direction(), bakedQuad.shade());
            this.putQuadData(blockAndTintGetter, blockState, blockPos, vertexConsumer, poseStack.last(), bakedQuad, (ModelBlockRenderer.CommonRenderStorage)ambientOcclusionRenderStorage, i);
        }
    }

    private void putQuadData(BlockAndTintGetter blockAndTintGetter, BlockState blockState, BlockPos blockPos, VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad bakedQuad, ModelBlockRenderer.CommonRenderStorage commonRenderStorage, int i) {
        float h;
        float g;
        float f;
        int j = bakedQuad.tintIndex();
        if (j != -1) {
            int k;
            if (commonRenderStorage.tintCacheIndex == j) {
                k = commonRenderStorage.tintCacheValue;
            } else {
                k = this.blockRenderer.getModelRenderer().blockColors.getColor(blockState, blockAndTintGetter, blockPos, j);
                commonRenderStorage.tintCacheIndex = j;
                commonRenderStorage.tintCacheValue = k;
            }
            f = ARGB.redFloat((int)k);
            g = ARGB.greenFloat((int)k);
            h = ARGB.blueFloat((int)k);
        } else {
            f = 1.0f;
            g = 1.0f;
            h = 1.0f;
        }
        vertexConsumer.putBulkData(pose, bakedQuad, commonRenderStorage.brightness, f, g, h, 1.0f, commonRenderStorage.lightmap, i, true);
    }

    private void calculateShape(BlockAndTintGetter blockAndTintGetter, BlockState blockState, BlockPos blockPos, int[] is, Direction direction, ModelBlockRenderer.CommonRenderStorage commonRenderStorage) {
        boolean var10001;
        float m;
        float f = 32.0f;
        float g = 32.0f;
        float h = 32.0f;
        float i = -32.0f;
        float j = -32.0f;
        float k = -32.0f;
        for (int l = 0; l < 4; ++l) {
            m = Float.intBitsToFloat(is[l * 8]);
            float n = Float.intBitsToFloat(is[l * 8 + 1]);
            float o = Float.intBitsToFloat(is[l * 8 + 2]);
            f = Math.min(f, m);
            g = Math.min(g, n);
            h = Math.min(h, o);
            i = Math.max(i, m);
            j = Math.max(j, n);
            k = Math.max(k, o);
        }
        if (commonRenderStorage instanceof ModelBlockRenderer.AmbientOcclusionRenderStorage) {
            ModelBlockRenderer.AmbientOcclusionRenderStorage ambientOcclusionRenderStorage = (ModelBlockRenderer.AmbientOcclusionRenderStorage)commonRenderStorage;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.WEST.index] = f;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.EAST.index] = i;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.DOWN.index] = g;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.UP.index] = j;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.NORTH.index] = h;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.SOUTH.index] = k;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.FLIP_WEST.index] = 1.0f - f;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.FLIP_EAST.index] = 1.0f - i;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.FLIP_DOWN.index] = 1.0f - g;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.FLIP_UP.index] = 1.0f - j;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.FLIP_NORTH.index] = 1.0f - h;
            ambientOcclusionRenderStorage.faceShape[ModelBlockRenderer.SizeInfo.FLIP_SOUTH.index] = 1.0f - k;
        }
        float p = 1.0E-4f;
        m = 0.9999f;
        commonRenderStorage.facePartial = var10001 = (switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> {
                if (f >= 1.0E-4f || h >= 1.0E-4f || i <= 0.9999f || k <= 0.9999f) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if (f >= 1.0E-4f || g >= 1.0E-4f || i <= 0.9999f || j <= 0.9999f) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST, Direction.EAST -> g >= 1.0E-4f || h >= 1.0E-4f || j <= 0.9999f || k <= 0.9999f;
        });
        commonRenderStorage.faceCubic = var10001 = (switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (g == j && (g < 1.0E-4f || blockState.isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, blockPos))) {
                    yield true;
                }
                yield false;
            }
            case Direction.UP -> {
                if (g == j && (j > 0.9999f || blockState.isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, blockPos))) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH -> {
                if (h == k && (h < 1.0E-4f || blockState.isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, blockPos))) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (h == k && (k > 0.9999f || blockState.isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, blockPos))) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (f == i && (f < 1.0E-4f || blockState.isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, blockPos))) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> f == i && (i > 0.9999f || blockState.isCollisionShapeFullBlock((BlockGetter)blockAndTintGetter, blockPos));
        });
    }

    private void renderModelFaceFlat(BlockAndTintGetter blockAndTintGetter, BlockState blockState, BlockPos blockPos, int i, int j, boolean bl, PoseStack poseStack, VertexConsumer vertexConsumer, List<BakedQuad> list, ModelBlockRenderer.CommonRenderStorage commonRenderStorage) {
        for (BakedQuad bakedQuad : list) {
            float f;
            if (bl) {
                this.calculateShape(blockAndTintGetter, blockState, blockPos, bakedQuad.vertices(), bakedQuad.direction(), commonRenderStorage);
                BlockPos blockPos2 = commonRenderStorage.faceCubic ? commonRenderStorage.scratchPos.setWithOffset((Vec3i)blockPos, bakedQuad.direction()) : blockPos;
                i = commonRenderStorage.cache.getLightColor(blockState, blockAndTintGetter, blockPos2);
            }
            commonRenderStorage.brightness[0] = f = blockAndTintGetter.getShade(bakedQuad.direction(), bakedQuad.shade());
            commonRenderStorage.brightness[1] = f;
            commonRenderStorage.brightness[2] = f;
            commonRenderStorage.brightness[3] = f;
            commonRenderStorage.lightmap[0] = i;
            commonRenderStorage.lightmap[1] = i;
            commonRenderStorage.lightmap[2] = i;
            commonRenderStorage.lightmap[3] = i;
            this.putQuadData(blockAndTintGetter, blockState, blockPos, vertexConsumer, poseStack.last(), bakedQuad, commonRenderStorage, j);
        }
    }
}

