/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.RopeDartModel;
import net.orcinus.galosphere.client.renderer.entity.state.RopeDartRenderState;
import net.orcinus.galosphere.entities.RopeDartProjectile;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GModelLayers;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RopeDartProjectileRenderer
extends ArrowRenderer<RopeDartProjectile, RopeDartRenderState> {
    public static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/projectiles/rope_dart.png");
    public static final ResourceLocation STRING_TEXTURE = Galosphere.id("textures/entity/projectiles/rope_dart_string.png");
    private final RopeDartModel model;

    public RopeDartProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RopeDartModel(context.bakeLayer(GModelLayers.ROPE_DART));
    }

    public RopeDartRenderState createRenderState() {
        return new RopeDartRenderState();
    }

    protected ResourceLocation getTextureLocation(RopeDartRenderState ropeDartRenderState) {
        return TEXTURE;
    }

    public void extractRenderState(RopeDartProjectile abstractArrow, RopeDartRenderState arrowRenderState, float f) {
        Player player = abstractArrow.getPlayerOwner();
        if (player == null) {
            return;
        }
        super.extractRenderState((AbstractArrow)abstractArrow, (ArrowRenderState)arrowRenderState, f);
        arrowRenderState.playerHandOffset = this.getPlayerHandPos(player, f, (Item)GItems.ROPE_DART.get(), Minecraft.getInstance().getEntityRenderDispatcher());
        arrowRenderState.entityPosition = new Vec3(abstractArrow.xo, abstractArrow.yo + (double)abstractArrow.getEyeHeight(), abstractArrow.zo);
        arrowRenderState.forward = abstractArrow.getForward();
    }

    public void render(RopeDartRenderState ropeDartRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.renderDart(ropeDartRenderState, poseStack, multiBufferSource, i);
        this.renderRope(ropeDartRenderState, poseStack, multiBufferSource);
    }

    private void renderDart(RopeDartRenderState ropeDartRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(ropeDartRenderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(ropeDartRenderState.xRot));
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(ropeDartRenderState)));
        this.model.setupAnim(ropeDartRenderState);
        this.model.renderToBuffer(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private void renderRope(RopeDartRenderState ropeDartRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        poseStack.pushPose();
        Vec3 vec3 = ropeDartRenderState.playerHandOffset;
        Vec3 vec32 = ropeDartRenderState.entityPosition;
        vec32.subtract(ropeDartRenderState.forward);
        float h = 1.0f;
        float j = h * 0.15f % 1.0f;
        Vec3 vec33 = vec3.subtract(vec32);
        float k = (float)(vec33.length() + 0.1);
        vec33 = vec33.normalize();
        float l = (float)Math.acos(vec33.y);
        float m = (float)Math.atan2(vec33.z, vec33.x);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((1.5707964f - m) * 57.295776f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(l * 57.295776f));
        float n = h * 0.05f * -1.5f;
        float p = Mth.cos((float)(n + (float)Math.PI)) * 0.2f;
        float q = Mth.sin((float)(n + (float)Math.PI)) * 0.2f;
        float r = Mth.cos((float)(n + 0.0f)) * 0.2f;
        float s = Mth.sin((float)(n + 0.0f)) * 0.2f;
        float aa = -1.0f + j;
        float ab = k * 2.5f + aa;
        VertexConsumer stringConsumer = multiBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)STRING_TEXTURE));
        PoseStack.Pose pose = poseStack.last();
        this.vertex(stringConsumer, pose, p, k, q, 0.4999f, ab);
        this.vertex(stringConsumer, pose, p, 0.0f, q, 0.4999f, aa);
        this.vertex(stringConsumer, pose, r, 0.0f, s, 0.0f, aa);
        this.vertex(stringConsumer, pose, r, k, s, 0.0f, ab);
        poseStack.popPose();
    }

    private Vec3 getPlayerHandPos(Player player, float f, Item item, EntityRenderDispatcher entityRenderDispatcher) {
        int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemStack = player.getMainHandItem();
        if (!itemStack.is(item)) {
            i = -i;
        }
        float g = player.getAttackAnim(f);
        float h = Mth.sin((float)(Mth.sqrt((float)g) * (float)Math.PI));
        float j = Mth.lerp((float)f, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d = Mth.sin((float)j);
        double e = Mth.cos((float)j);
        double k = (double)i * 0.35;
        if (entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double n = 960.0 / (double)((Integer)entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = entityRenderDispatcher.camera.getNearPlane().getBottomRight();
            vec3 = vec3.scale(n);
            vec3 = vec3.yRot(h * 0.5f);
            vec3 = vec3.xRot(-h * 0.7f);
            return new Vec3(Mth.lerp((double)f, (double)player.xo, (double)player.getX()) + vec3.x, Mth.lerp((double)f, (double)player.yo, (double)player.getY()) + vec3.y + (double)player.getEyeHeight(), Mth.lerp((double)f, (double)player.zo, (double)player.getZ()) + vec3.z);
        }
        float m = player.isCrouching() ? -0.1875f : 0.0f;
        double xPosition = Mth.lerp((double)f, (double)player.xo, (double)player.getX()) - e * k - d * 0.4;
        double yPosition = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)f - 0.45 + (double)m;
        double zPosition = Mth.lerp((double)f, (double)player.zo, (double)player.getZ()) - d * k + e * 0.4;
        return new Vec3(xPosition, yPosition + 0.9, zPosition);
    }

    private void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, float f, float g, float h, float i, float j) {
        int color = 0x323232;
        Vector3f vector3f = Vec3.fromRGB24((int)color).toVector3f();
        float red = vector3f.x;
        float green = vector3f.y;
        float blue = vector3f.z;
        float alpha = 255.0f;
        vertexConsumer.addVertex(pose, f, g, h).setColor(red, green, blue, alpha).setUv(i, j).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }
}

