/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.model.SparkleModel;
import net.orcinus.galosphere.client.renderer.entity.state.SparkleRenderState;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.variants.SparkleVariant;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class SparkleRenderer
extends AgeableMobRenderer<Sparkle, SparkleRenderState, SparkleModel> {
    public SparkleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SparkleModel(context.bakeLayer(GModelLayers.SPARKLE)), (EntityModel)new SparkleModel(context.bakeLayer(GModelLayers.SPARKLE_BABY)), 0.4f);
    }

    public SparkleRenderState createRenderState() {
        return new SparkleRenderState();
    }

    public ResourceLocation getTextureLocation(SparkleRenderState sparkleRenderState) {
        return sparkleRenderState.variant == null ? MissingTextureAtlasSprite.getLocation() : sparkleRenderState.variant.assetInfo().texturePath();
    }

    public void extractRenderState(Sparkle livingEntity, SparkleRenderState sparkleRenderState, float f) {
        super.extractRenderState((LivingEntity)livingEntity, (LivingEntityRenderState)sparkleRenderState, f);
        sparkleRenderState.variant = (SparkleVariant)livingEntity.getVariant().value();
        sparkleRenderState.inWaterFactor = livingEntity.inWaterAnimator.getFactor(f);
        sparkleRenderState.movingFactor = livingEntity.movingAnimator.getFactor(f);
    }
}

