/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.SpectreModel;
import net.orcinus.galosphere.client.renderer.entity.state.SpectreRenderState;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class SpectreRenderer
extends MobRenderer<Spectre, SpectreRenderState, SpectreModel> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/spectre/spectre.png");
    private static final ResourceLocation LINKED_TEXTURE = Galosphere.id("textures/entity/spectre/spectre_linked.png");

    public SpectreRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SpectreModel(context.bakeLayer(GModelLayers.SPECTRE)), 0.1f);
    }

    protected int getBlockLightLevel(Spectre entity, BlockPos blockPos) {
        return 15;
    }

    public SpectreRenderState createRenderState() {
        return new SpectreRenderState();
    }

    public void extractRenderState(Spectre livingEntity, SpectreRenderState livingEntityRenderState, float f) {
        super.extractRenderState((LivingEntity)livingEntity, (LivingEntityRenderState)livingEntityRenderState, f);
        livingEntityRenderState.hasManipulator = livingEntity.getManipulatorUUID() != null;
    }

    public ResourceLocation getTextureLocation(SpectreRenderState livingEntityRenderState) {
        return livingEntityRenderState.hasManipulator ? LINKED_TEXTURE : TEXTURE;
    }
}

