/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.renderer.entity.state.ThrowableLaunchedProjectileRenderState;
import net.orcinus.galosphere.entities.ThrowableLaunchedProjectile;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ThrowableLaunchedProjectileRenderer
extends EntityRenderer<ThrowableLaunchedProjectile, ThrowableLaunchedProjectileRenderState> {
    private final ItemModelResolver itemModelResolver;

    public ThrowableLaunchedProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public ThrowableLaunchedProjectileRenderState createRenderState() {
        return new ThrowableLaunchedProjectileRenderState();
    }

    public void extractRenderState(ThrowableLaunchedProjectile entity, ThrowableLaunchedProjectileRenderState entityRenderState, float f) {
        super.extractRenderState((Entity)entity, (EntityRenderState)entityRenderState, f);
        entityRenderState.shotAtAngle = entity.isShotAtAngle();
        this.itemModelResolver.updateForNonLiving(entityRenderState.item, entity.getItem(), ItemDisplayContext.GROUND, (Entity)entity);
    }

    public void render(ThrowableLaunchedProjectileRenderState entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        if (entityRenderState.isShotAtAngle) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        }
        entityRenderState.item.render(poseStack, multiBufferSource, i, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)entityRenderState, poseStack, multiBufferSource, i);
    }
}

