/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.WeaponRackModel;
import net.orcinus.galosphere.client.renderer.entity.state.WeaponRackRenderState;
import net.orcinus.galosphere.entities.WeaponRack;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GModelLayers;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class WeaponRackRenderer
extends EntityRenderer<WeaponRack, WeaponRackRenderState> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/weapon_rack/weapon_rack.png");
    private final ItemModelResolver itemModelResolver;
    private final WeaponRackModel model;

    public WeaponRackRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WeaponRackModel(context.bakeLayer(GModelLayers.WEAPON_RACK));
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(WeaponRackRenderState entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        float g;
        float f;
        super.render((EntityRenderState)entityRenderState, poseStack, multiBufferSource, i);
        poseStack.pushPose();
        Direction direction = entityRenderState.direction;
        Vec3 vec3 = this.getRenderOffset(entityRenderState);
        poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
        poseStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        if (direction.getAxis().isHorizontal()) {
            f = 0.0f;
            g = 180.0f - direction.toYRot();
        } else {
            f = -90 * direction.getAxisDirection().getStep();
            g = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(g));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(135.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)entityRenderState.rotation * 360.0f / 8.0f));
        poseStack.pushPose();
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        poseStack.translate(0.0f, -1.0f, 0.0f);
        this.model.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        float shift = entityRenderState.shift;
        float yShift = entityRenderState.yShift;
        poseStack.translate(shift, yShift, 0.4675f);
        float rotation = entityRenderState.projectileRotation;
        if (!entityRenderState.item.isEmpty()) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotation));
            poseStack.scale(1.0f, 1.0f, 1.0f);
            entityRenderState.item.render(poseStack, multiBufferSource, i, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    public void extractRenderState(WeaponRack entity, WeaponRackRenderState entityRenderState, float f) {
        super.extractRenderState((Entity)entity, (EntityRenderState)entityRenderState, f);
        ItemStack itemStack = entity.getItem();
        boolean ranged = itemStack.is(Tags.Items.RANGED_WEAPON_TOOLS) && !itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS);
        boolean nonTools = itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS) || ranged || itemStack.is(Tags.Items.TOOLS_BRUSH);
        this.itemModelResolver.updateForNonLiving(entityRenderState.item, itemStack, ItemDisplayContext.FIXED, (Entity)entity);
        entityRenderState.direction = entity.getDirection();
        entityRenderState.rotation = entity.getRotation();
        float f2 = entityRenderState.shift = nonTools ? 0.0f : -0.05f;
        if (ranged) {
            entityRenderState.yShift = -0.015f;
            entityRenderState.projectileRotation = 45.0f;
        } else {
            entityRenderState.yShift = -0.035f;
            entityRenderState.projectileRotation = 135.0f;
        }
        if (itemStack.is((Item)GItems.ECHO_BELL.get())) {
            entityRenderState.shift = 0.01f;
            entityRenderState.yShift = -0.095f;
        }
    }

    public Vec3 getRenderOffset(WeaponRackRenderState entityRenderState) {
        return new Vec3((double)((float)entityRenderState.direction.getStepX() * 0.3f), -0.25, (double)((float)entityRenderState.direction.getStepZ() * 0.3f));
    }

    public WeaponRackRenderState createRenderState() {
        return new WeaponRackRenderState();
    }
}

