/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.events.ClientEvents;

@OnlyIn(value=Dist.CLIENT)
public class SaltStatueLayer<S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends RenderLayer<S, M> {
    private static final ResourceLocation SALT_TEXTURE = Galosphere.id("textures/block/pink_salt.png");

    public SaltStatueLayer(RenderLayerParent<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, S entityRenderState, float f, float g) {
        boolean flag = (Boolean)entityRenderState.getRenderDataOrDefault(ClientEvents.HALITE_TICKS, (Object)false);
        if (flag) {
            SheetedDecalTextureGenerator vertexConsumer = new SheetedDecalTextureGenerator(multiBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)SALT_TEXTURE)), poseStack.last(), 1.0f);
            this.getParentModel().renderToBuffer(poseStack, (VertexConsumer)vertexConsumer, i, OverlayTexture.NO_OVERLAY, 0);
        }
    }
}

