/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SterlingHelmetTooltip
implements ClientTooltipComponent {
    private ModelPart flag;
    private final ItemStack itemStack;
    private static final Component DESCRIPTION = Component.translatable((String)"item.galosphere.sterling_helmet.empty.description");

    public SterlingHelmetTooltip(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getHeight(Font font) {
        int n;
        if (this.itemStack.isEmpty()) {
            Objects.requireNonNull(font);
            n = 9;
        } else {
            n = 28;
        }
        return n;
    }

    public int getWidth(Font font) {
        return 0;
    }

    public void renderImage(Font font, int i, int j, int k, int l, GuiGraphics guiGraphics) {
        if (this.flag == null) {
            this.flag = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.STANDING_BANNER_FLAG).getChild("flag");
        }
        if (this.itemStack.isEmpty()) {
            guiGraphics.drawWordWrap(font, (FormattedText)DESCRIPTION, i, j, 96, 0xAAAAAA);
        } else {
            Item item = this.itemStack.getItem();
            if (!(item instanceof BannerItem)) {
                return;
            }
            BannerItem bannerItem = (BannerItem)item;
            BannerPatternLayers bannerPatternLayers = (BannerPatternLayers)this.itemStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            float size = 12.0f;
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)(i + 12), (float)(j + 33), 8.0f);
            pose.scale(size, size, 1.0f);
            guiGraphics.drawSpecial(multiBufferSource -> BannerRenderer.renderPatterns((PoseStack)guiGraphics.pose(), (MultiBufferSource)multiBufferSource, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)bannerItem.getColor(), (BannerPatternLayers)bannerPatternLayers));
            pose.popPose();
        }
    }
}

