/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GSoundEvents;

public class LumiereComposterDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    public ItemStack execute(BlockSource source, ItemStack stack) {
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos blockpos = source.pos().relative(direction);
        ServerLevel world = source.level();
        BlockState state = world.getBlockState(blockpos);
        this.setSuccess(true);
        if (state.is(Blocks.COMPOSTER)) {
            if ((Integer)state.getValue((Property)ComposterBlock.LEVEL) > 0) {
                world.playSound(null, blockpos, GSoundEvents.LUMIERE_COMPOST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                world.setBlock(blockpos, (BlockState)((Block)GBlocks.LUMIERE_COMPOSTER.get()).defaultBlockState().setValue((Property)ComposterBlock.LEVEL, (Comparable)((Integer)state.getValue((Property)ComposterBlock.LEVEL))), 2);
                stack.shrink(1);
            } else {
                this.setSuccess(false);
            }
            return stack;
        }
        return super.execute(source, stack);
    }
}

