/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.init.GSparkleVariants;

public class PickaxeDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
        ServerLevel level = blockSource.level();
        if (!level.isClientSide()) {
            BlockPos blockpos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
            this.setSuccess(PickaxeDispenseItemBehavior.extractItemFromEntity(level, blockpos, itemStack));
            if (this.isSuccess()) {
                itemStack.hurtAndBreak(1, level, null, item -> {});
            }
        }
        return itemStack;
    }

    private static boolean extractItemFromEntity(ServerLevel world, BlockPos blockPos, ItemStack stack) {
        for (Sparkle livingentity : world.getEntitiesOfClass(Sparkle.class, new AABB(blockPos), EntitySelector.NO_SPECTATORS)) {
            if (livingentity == null || livingentity.getVariant() == GSparkleVariants.DEFAULT) continue;
            livingentity.extractShard(stack);
            world.gameEvent(null, (Holder)GameEvent.SHEAR, blockPos);
            return true;
        }
        return false;
    }
}

