/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.init.GBiomeTags;
import net.orcinus.galosphere.init.GBiomes;

public class GBiomeTagsProvider
extends BiomeTagsProvider {
    public GBiomeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider, "galosphere");
    }

    protected void addTags(HolderLookup.Provider provider) {
        GBiomes.BIOMES.forEach(this::addBiomeTag);
        this.tag(GBiomeTags.HAS_PINK_SALT_SHRINE).addOptional(GBiomes.PINK_SALT_CAVES.location());
        this.tag(GBiomeTags.HAS_FORGOTTEN_RUINS).addOptionalTag(BiomeTags.IS_RIVER).addOptionalTag(BiomeTags.IS_MOUNTAIN).addOptionalTag(BiomeTags.IS_HILL).addOptionalTag(BiomeTags.IS_TAIGA).addOptionalTag(BiomeTags.IS_JUNGLE).addOptionalTag(BiomeTags.IS_FOREST).add(Biomes.STONY_SHORE).add(Biomes.MUSHROOM_FIELDS).add(Biomes.ICE_SPIKES).add(Biomes.WINDSWEPT_SAVANNA).add(Biomes.DESERT).add(Biomes.SAVANNA).add(Biomes.SNOWY_PLAINS).add(Biomes.PLAINS).add(Biomes.SUNFLOWER_PLAINS).add(Biomes.SWAMP).add(Biomes.MANGROVE_SWAMP).add(Biomes.SAVANNA_PLATEAU).add(Biomes.DEEP_DARK).add(Biomes.DRIPSTONE_CAVES).add(Biomes.LUSH_CAVES);
    }

    public void addBiomeTag(ResourceKey<Biome> biome) {
        this.tag(BiomeTags.HAS_MINESHAFT).addOptional(biome.location());
        this.tag(BiomeTags.HAS_RUINED_PORTAL_STANDARD).addOptional(biome.location());
        this.tag(BiomeTags.STRONGHOLD_BIASED_TO).addOptional(biome.location());
        this.tag(BiomeTags.IS_OVERWORLD).addOptional(biome.location());
        this.tag(Tags.Biomes.IS_UNDERGROUND).addOptional(biome.location());
    }
}

