/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.orcinus.galosphere.datagen.GAdvancementProvider;
import net.orcinus.galosphere.datagen.GBiomeTagsProvider;
import net.orcinus.galosphere.datagen.GBlockTagsProvider;
import net.orcinus.galosphere.datagen.GDataMapProvider;
import net.orcinus.galosphere.datagen.GDatapackBuiltinEntriesProvider;
import net.orcinus.galosphere.datagen.GEnchantmentTagsProvider;
import net.orcinus.galosphere.datagen.GEntityTypeTagsProvider;
import net.orcinus.galosphere.datagen.GItemTagsProvider;
import net.orcinus.galosphere.datagen.GLanguageProvider;
import net.orcinus.galosphere.datagen.GLootModifierProvider;
import net.orcinus.galosphere.datagen.GLootTableProvider;
import net.orcinus.galosphere.datagen.GModelProvider;
import net.orcinus.galosphere.datagen.GRecipeProvider;
import net.orcinus.galosphere.datagen.GStructureTagsProvider;

@EventBusSubscriber(modid="galosphere", bus=EventBusSubscriber.Bus.MOD)
public class GDataGenerator {
    @SubscribeEvent
    public static void gatherClientData(GatherDataEvent.Client event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new GLootTableProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GRecipeProvider.Runner(packOutput, lookupProvider));
        GBlockTagsProvider blockTagsProvider = new GBlockTagsProvider(packOutput, lookupProvider);
        event.addProvider((DataProvider)blockTagsProvider);
        event.addProvider((DataProvider)new GItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        event.addProvider((DataProvider)new GLanguageProvider(packOutput));
        event.addProvider((DataProvider)new GModelProvider(packOutput));
        event.addProvider((DataProvider)new GAdvancementProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GEntityTypeTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GStructureTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GBiomeTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GEnchantmentTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GLootModifierProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GDataMapProvider(packOutput, lookupProvider));
    }

    @SubscribeEvent
    public static void gatherServerData(GatherDataEvent.Server event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new GLootTableProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GRecipeProvider.Runner(packOutput, lookupProvider));
        GBlockTagsProvider blockTagsProvider = new GBlockTagsProvider(packOutput, lookupProvider);
        event.addProvider((DataProvider)blockTagsProvider);
        event.addProvider((DataProvider)new GItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        event.addProvider((DataProvider)new GEntityTypeTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GStructureTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GBiomeTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GEnchantmentTagsProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GLootModifierProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new GDataMapProvider(packOutput, lookupProvider));
    }
}

