/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.function.Function;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.blocks.MoleBurrowBlock;
import net.orcinus.galosphere.blocks.PinkSaltStrawBlock;
import net.orcinus.galosphere.init.GBlockFamilies;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GModelTemplates;
import net.orcinus.galosphere.items.properties.Cooldown;
import net.orcinus.galosphere.items.properties.MiningPouchFilled;
import net.orcinus.galosphere.items.properties.MonstrometerFueled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GModelProvider
extends ModelProvider {
    @Nullable
    private MultiVariant lightStandTop = null;
    @Nullable
    private MultiVariant lightStandBottom = null;

    public GModelProvider(PackOutput packOutput) {
        super(packOutput, "galosphere");
    }

    protected void registerModels(BlockModelGenerators blockModelGenerators, ItemModelGenerators itemModelGenerators) {
        GBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(family -> blockModelGenerators.family(family.getBaseBlock()).generateFor(family));
        GModelProvider.createChiseledPinkSalt(blockModelGenerators, GBlocks.POLISHED_PINK_SALT, GBlocks.CHISELED_PINK_SALT);
        GModelProvider.createChiseledPinkSalt(blockModelGenerators, GBlocks.POLISHED_ROSE_PINK_SALT, GBlocks.CHISELED_ROSE_PINK_SALT);
        GModelProvider.createChiseledPinkSalt(blockModelGenerators, GBlocks.POLISHED_PASTEL_PINK_SALT, GBlocks.CHISELED_PASTEL_PINK_SALT);
        blockModelGenerators.createTrivialCube((Block)GBlocks.OPAL_BLOCK.get());
        blockModelGenerators.createTrivialBlock((Block)GBlocks.OPAL_LEAVES.get(), TexturedModel.LEAVES);
        blockModelGenerators.woodProvider((Block)GBlocks.OPAL_LOG.get()).logWithHorizontal((Block)GBlocks.OPAL_LOG.get());
        blockModelGenerators.createPlantWithDefaultItem((Block)GBlocks.OPAL_SAPLING.get(), (Block)GBlocks.POTTED_OPAL_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        GModelProvider.createLichenShelf(blockModelGenerators);
        GModelProvider.createCordyceps(blockModelGenerators);
        GModelProvider.createLichenVines(blockModelGenerators);
        GModelProvider.createChandelier(blockModelGenerators, (Block)GBlocks.CHANDELIER.get());
        GModelProvider.createChandelier(blockModelGenerators, (Block)GBlocks.SOUL_CHANDELIER.get());
        GModelProvider.createPalladiumLattice(blockModelGenerators, GBlocks.PALLADIUM_LATTICE);
        GModelProvider.createPalladiumLattice(blockModelGenerators, GBlocks.GLOW_BERRIES_PALLADIUM_LATTICE);
        GModelProvider.createFilledComposter(blockModelGenerators, GBlocks.LUMIERE_COMPOSTER);
        GModelProvider.createFilledComposter(blockModelGenerators, GBlocks.SALINE_COMPOSTER);
        this.createLightStand(blockModelGenerators, GBlocks.LIGHT_STAND);
        this.createLightStand(blockModelGenerators, GBlocks.SOUL_LIGHT_STAND);
        GModelProvider.createMoleBurrow(blockModelGenerators);
        blockModelGenerators.createTrivialCube((Block)GBlocks.TUFF_DIRT.get());
        blockModelGenerators.createMultiface((Block)GBlocks.GLOW_INK_CLUMPS.get());
        blockModelGenerators.createMultiface((Block)GBlocks.PALLADIUM_DUST.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.AMETHYST_LAMP.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.ALLURITE_LAMP.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.LUMIERE_LAMP.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.RAW_PALLADIUM_BLOCK.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.PALLADIUM_BLOCK.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.PALLADIUM_ORE.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get());
        GModelProvider.createLichenMoss(blockModelGenerators);
        blockModelGenerators.createPlantWithDefaultItem((Block)GBlocks.LICHEN_ROOTS.get(), (Block)GBlocks.POTTED_LICHEN_ROOTS.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockModelGenerators.createPlantWithDefaultItem((Block)GBlocks.BOWL_LICHEN.get(), (Block)GBlocks.POTTED_BOWL_LICHEN.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        GModelProvider.createCombustionTable(blockModelGenerators);
        GModelProvider.createBurrowAnchor(blockModelGenerators);
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.ALLURITE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.LUMIERE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.CURED_MEMBRANE_BLOCK.get());
        GModelProvider.createShadowFrame(blockModelGenerators);
        GModelProvider.createStrandedMembrane(blockModelGenerators);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)GBlocks.GILDED_BEADS.get()), (MultiVariant)blockModelGenerators.createParticleOnlyBlockModel((Block)GBlocks.GILDED_BEADS.get(), Blocks.GOLD_BLOCK)));
        GModelProvider.createPinkSaltStraw(blockModelGenerators);
        GModelProvider.createPinkSaltCluster(blockModelGenerators);
        GModelProvider.createPinkSaltLamp(blockModelGenerators);
        this.generateItemModels(itemModelGenerators);
    }

    private static void createMoleBurrow(BlockModelGenerators blockModelGenerators) {
        blockModelGenerators.registerSimpleItemModel((Block)GBlocks.MOLE_BURROW.get(), ModelLocationUtils.getModelLocation((Block)((Block)GBlocks.MOLE_BURROW.get()), (String)"_top_pouch_0"));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.MOLE_BURROW.get())).with(PropertyDispatch.initial((Property)MoleBurrowBlock.POUCHES).generate(integer -> BlockModelGenerators.plainVariant((ResourceLocation)blockModelGenerators.createSuffixedVariant((Block)GBlocks.MOLE_BURROW.get(), "_top_pouch_" + integer, ModelTemplates.CUBE_TOP, resourceLocation -> {
            Object suffix = integer == 0 ? "_top" : "_top_pouch_" + integer;
            return new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)GBlocks.MOLE_BURROW.get()), (String)suffix)).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.MOLE_BURROW.get()), (String)"_side"));
        })))));
    }

    private static void createCordyceps(BlockModelGenerators blockModelGenerators) {
        ResourceLocation bulbTexture = blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_CORDYCEPS.get(), "_bulb", ModelTemplates.CROSS, TextureMapping::cross);
        MultiVariant bulbVariant = BlockModelGenerators.plainVariant((ResourceLocation)bulbTexture);
        ResourceLocation cordyceps = blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_CORDYCEPS.get(), "", ModelTemplates.CROSS, TextureMapping::cross);
        MultiVariant variant = BlockModelGenerators.plainVariant((ResourceLocation)cordyceps);
        Function<Integer, MultiVariant> function = integer -> BlockModelGenerators.plainVariant((ResourceLocation)blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_CORDYCEPS.get(), "_alive_stage_" + integer, ModelTemplates.CROSS, TextureMapping::cross));
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)GBlocks.LICHEN_CORDYCEPS.get())).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.BULB, (Comparable)Boolean.valueOf(true)), bulbVariant).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(0)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(0)).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(1)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(1)).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(2)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(2)).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(3)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(3)).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(4)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(4)).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(5)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(5)).with(BlockModelGenerators.condition().term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(false)), variant));
        blockModelGenerators.createCrossBlock((Block)GBlocks.LICHEN_CORDYCEPS_PLANT.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockModelGenerators.registerSimpleFlatItemModel(((Block)GBlocks.LICHEN_CORDYCEPS.get()).asItem());
    }

    private static void createPinkSaltLamp(BlockModelGenerators blockModelGenerators) {
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)GModelTemplates.PINK_SALT_LAMP.create((Block)GBlocks.PINK_SALT_LAMP.get(), TextureMapping.defaultTexture((Block)((Block)GBlocks.PINK_SALT_LAMP.get())), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.PINK_SALT_LAMP.get()), (MultiVariant)multivariant).with(BlockModelGenerators.ROTATIONS_COLUMN_WITH_FACING));
    }

    private static void createPinkSaltCluster(BlockModelGenerators blockModelGenerators) {
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)GModelTemplates.PINK_SALT_CLUSTER.create((Block)GBlocks.PINK_SALT_CLUSTER.get(), TextureMapping.defaultTexture((Block)((Block)GBlocks.PINK_SALT_CLUSTER.get())), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.PINK_SALT_CLUSTER.get()), (MultiVariant)multivariant).with(BlockModelGenerators.ROTATIONS_COLUMN_WITH_FACING));
    }

    private static void createChiseledPinkSalt(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> polished, DeferredBlock<Block> block) {
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)((Block)block.get()))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side")).put(GModelTemplates.GTextureSlots.SMOOTH, TextureMapping.getBlockTexture((Block)((Block)polished.get())));
        ResourceLocation resourceLocation = GModelTemplates.CHISELED_ORIENTABLE.create((Block)block.get(), textureMapping, blockModelGenerators.modelOutput);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)resourceLocation)).with(PropertyDispatch.modify((Property)BlockStateProperties.ORIENTATION).generate(BlockModelGenerators::applyRotation)));
    }

    private static void createChandelier(BlockModelGenerators blockModelGenerators, Block block) {
        TextureMapping base = new TextureMapping().put(GModelTemplates.GTextureSlots.BASE, Galosphere.id("block/chandelier_base")).put(GModelTemplates.GTextureSlots.BASE_SIDE, Galosphere.id("block/chandelier_base_side")).put(GModelTemplates.GTextureSlots.CHAIN, Galosphere.id("block/chandelier_chain")).put(GModelTemplates.GTextureSlots.FIRE, TextureMapping.getBlockTexture((Block)block, (String)"_fire")).put(TextureSlot.PARTICLE, Galosphere.id("block/chandelier_base_side"));
        ResourceLocation chandelier = GModelTemplates.CHANDELIER.create(block, base, blockModelGenerators.modelOutput);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)chandelier)));
    }

    private static void createPalladiumLattice(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> block) {
        Block lattice = (Block)block.get();
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)lattice, (String)"_post_ends"));
        MultiVariant multivariant1 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)lattice, (String)"_post"));
        MultiVariant multivariant2 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)lattice, (String)"_cap"));
        MultiVariant multivariant3 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)lattice, (String)"_cap_alt"));
        MultiVariant multivariant4 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)lattice, (String)"_side"));
        MultiVariant multivariant5 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)lattice, (String)"_side_alt"));
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)lattice).with(multivariant).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), multivariant1).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), multivariant2).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), multivariant2.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), multivariant3).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), multivariant3.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), multivariant4).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), multivariant4.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), multivariant5).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), multivariant5.with(BlockModelGenerators.Y_ROT_90)));
        blockModelGenerators.registerSimpleFlatItemModel(lattice);
    }

    private static void createFilledComposter(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> composter) {
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)composter.get())).with(BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(1)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents1"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(2)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents2"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(3)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents3"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(4)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents4"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(5)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents5"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(6)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents6"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(7)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents7"))).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(8)), BlockModelGenerators.plainVariant((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents_ready"))));
    }

    private void createLightStand(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> lightStand) {
        blockModelGenerators.registerSimpleFlatItemModel((Block)lightStand.get(), "_top_lit");
        if (this.lightStandBottom == null) {
            this.lightStandBottom = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CROSS.create(Galosphere.id("block/light_stand_bottom"), new TextureMapping().put(TextureSlot.CROSS, Galosphere.id("block/light_stand_bottom")), blockModelGenerators.modelOutput));
        }
        if (this.lightStandTop == null) {
            this.lightStandTop = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CROSS.create(Galosphere.id("block/light_stand_top"), new TextureMapping().put(TextureSlot.CROSS, Galosphere.id("block/light_stand_top")), blockModelGenerators.modelOutput));
        }
        MultiVariant litTopVariant = BlockModelGenerators.plainVariant((ResourceLocation)blockModelGenerators.createSuffixedVariant((Block)lightStand.get(), "_top_lit", ModelTemplates.CROSS, TextureMapping::cross));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)lightStand.get())).with(PropertyDispatch.initial((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Property)BlockStateProperties.LIT).generate((half, bool) -> {
            if (half == DoubleBlockHalf.LOWER) {
                return this.lightStandBottom;
            }
            return bool != false ? litTopVariant : this.lightStandTop;
        })));
    }

    private static void createLichenVines(BlockModelGenerators blockModelGenerators) {
        MultiVariant multiVariant = BlockModelGenerators.plainVariant((ResourceLocation)Galosphere.id("block/lichen_vines"));
        PropertyDispatch.C1 select = PropertyDispatch.modify((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, (Object)BlockModelGenerators.Y_ROT_270).select((Comparable)Direction.SOUTH, (Object)BlockModelGenerators.NOP).select((Comparable)Direction.WEST, (Object)BlockModelGenerators.Y_ROT_90).select((Comparable)Direction.NORTH, (Object)BlockModelGenerators.Y_ROT_180);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)GBlocks.LICHEN_VINES.get()), (MultiVariant)multiVariant).with((PropertyDispatch)select));
    }

    private static void createLichenShelf(BlockModelGenerators blockModelGenerators) {
        TexturedModel texturedmodel = TexturedModel.CORAL_FAN.get((Block)GBlocks.LICHEN_SHELF.get());
        MultiVariant multivariant1 = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CORAL_WALL_FAN.create((Block)GBlocks.LICHEN_SHELF.get(), texturedmodel.getMapping(), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.LICHEN_SHELF.get()), (MultiVariant)multivariant1).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
        blockModelGenerators.registerSimpleFlatItemModel((Block)GBlocks.LICHEN_SHELF.get());
    }

    private static void createBurrowAnchor(BlockModelGenerators blockModelGenerators) {
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_side")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom"));
        ResourceLocation resourceLocation = GModelTemplates.BURROW_ANCHOR.create((Block)GBlocks.BURROW_ANCHOR.get(), textureMapping, blockModelGenerators.modelOutput);
        TextureMapping textureMapping1 = new TextureMapping().put(TextureSlot.TOP, BuiltInRegistries.BLOCK.getKey((Object)((Block)GBlocks.BURROW_ANCHOR.get())).withPath(string -> "block/powered_" + string)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_side")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom"));
        ResourceLocation resourceLocation1 = GModelTemplates.BURROW_ANCHOR.create(Galosphere.id("block/powered_burrow_anchor"), textureMapping1, blockModelGenerators.modelOutput);
        MultiVariant multiVariant = BlockModelGenerators.plainVariant((ResourceLocation)resourceLocation);
        MultiVariant multiVariant1 = BlockModelGenerators.plainVariant((ResourceLocation)resourceLocation1);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.BURROW_ANCHOR.get())).with(PropertyDispatch.initial((Property)BlockStateProperties.POWERED).generate(bool -> bool != false ? multiVariant1 : multiVariant)));
    }

    private void generateItemModels(ItemModelGenerators itemModelGenerators) {
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.ALLURITE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.LUMIERE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.LICHEN_VINES.get());
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.PINK_SALT_STRAW);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.CHANDELIER);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.SOUL_CHANDELIER);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.ALLURITE_SHARD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.LUMIERE_SHARD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PINK_SALT_SHARD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.RAW_PALLADIUM);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PALLADIUM_INGOT);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PALLADIUM_NUGGET);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PALLADIUM_BOMB);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PRESERVED_TEMPLATE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.GLOW_FLARE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SPECTRE_FLARE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PRESERVED_FLESH);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.GOLDEN_LICHEN_CORDYCEPS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.ICON_ITEM);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.GILDED_BEADS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.CURED_MEMBRANE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_HELMET);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_CHESTPLATE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_LEGGINGS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_BOOTS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_HORSE_ARMOR);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SALTED_JERKY);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.BOTTLE_OF_SPECTRE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.PINK_SALT_CLUSTER);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SHRINE_KEY);
        this.createHandheldItem(itemModelGenerators, (ItemLike)GItems.ECHO_BELL);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.THIRST_POTTERY_SHERD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.WAVE_POTTERY_SHERD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.OPAL_FLAKES);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.FAITH_ARMOR_TRIM_SMITHING_TEMPLATE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.OPAL);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.WEAPON_RACK);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SILVERFISH);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.BROKEN_ECHO_BELL);
        GItems.ITEMS.getEntries().stream().map(DeferredHolder::get).filter(SpawnEggItem.class::isInstance).forEach(item -> this.createGeneratedItem(itemModelGenerators, (ItemLike)item));
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)Items.SPYGLASS));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)Items.SPYGLASS, (String)"_in_hand"));
        itemModelGenerators.itemModelOutput.accept((Item)GItems.SPECTRE_BOUND_SPYGLASS.get(), ItemModelGenerators.createFlatModelDispatch((ItemModel.Unbaked)unbaked, (ItemModel.Unbaked)unbaked2));
        this.generateMiningPouch(itemModelGenerators);
        this.generateRopeDart(itemModelGenerators);
        this.generateSaltboundTablet(itemModelGenerators);
        this.generateMonstrometer(itemModelGenerators);
    }

    private void generateMonstrometer(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.MONSTROMETER.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_fueled", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, (ConditionalItemModelProperty)new MonstrometerFueled(), unbaked2, unbaked);
    }

    private void generateSaltboundTablet(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.SALTBOUND_TABLET.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_using", ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked3 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_cooldown", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), unbaked2, ItemModelUtils.conditional((ConditionalItemModelProperty)new Cooldown(), (ItemModel.Unbaked)unbaked3, (ItemModel.Unbaked)unbaked));
    }

    private void generateRopeDart(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.ROPE_DART.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_using", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), unbaked2, unbaked);
    }

    private void generateMiningPouch(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.MINING_POUCH.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_filled", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, (ConditionalItemModelProperty)new MiningPouchFilled(), unbaked2, unbaked);
    }

    private void createItemBlockDir(ItemModelGenerators itemModelGenerators, Block block) {
        itemModelGenerators.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModelWithBlockTexture(itemModelGenerators, block.asItem(), block)));
    }

    public ResourceLocation createFlatItemModelWithBlockTexture(ItemModelGenerators itemModelGenerators, Item item, Block block) {
        return ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Block)block), itemModelGenerators.modelOutput);
    }

    private void createGeneratedItem(ItemModelGenerators itemModelGenerators, ItemLike item) {
        itemModelGenerators.generateFlatItem(item.asItem(), ModelTemplates.FLAT_ITEM);
    }

    private void createHandheldItem(ItemModelGenerators itemModelGenerators, ItemLike item) {
        itemModelGenerators.generateFlatItem(item.asItem(), ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    private static void createStrandedMembrane(BlockModelGenerators blockModelGenerators) {
        Block block = (Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get();
        ResourceLocation bottom = TextureMapping.getBlockTexture((Block)block, (String)"_bottom");
        ResourceLocation top = TextureMapping.getBlockTexture((Block)block, (String)"_top");
        ResourceLocation side = TextureMapping.getBlockTexture((Block)block, (String)"_side");
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.BOTTOM, bottom).put(TextureSlot.TOP, top).put(TextureSlot.SIDE, side);
        MultiVariant multiVariant = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.create(block, textureMapping, blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockStateProperties.FACING).select((Comparable)Direction.DOWN, (Object)multiVariant.with(BlockModelGenerators.X_ROT_180)).select((Comparable)Direction.EAST, (Object)multiVariant.with(BlockModelGenerators.X_ROT_90).with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Object)multiVariant.with(BlockModelGenerators.X_ROT_90)).select((Comparable)Direction.SOUTH, (Object)multiVariant.with(BlockModelGenerators.Y_ROT_180).with(BlockModelGenerators.X_ROT_90)).select((Comparable)Direction.UP, (Object)multiVariant).select((Comparable)Direction.WEST, (Object)multiVariant.with(BlockModelGenerators.X_ROT_90).with(BlockModelGenerators.Y_ROT_270))));
    }

    private static void createCombustionTable(BlockModelGenerators blockModelGenerators) {
        ResourceLocation bottom = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_bottom");
        ResourceLocation top = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_top");
        ResourceLocation side0 = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_side0");
        ResourceLocation side1 = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_side1");
        ResourceLocation side2 = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_side2");
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.DOWN, bottom).put(TextureSlot.UP, top).put(TextureSlot.EAST, side1).put(TextureSlot.NORTH, side2).put(TextureSlot.SOUTH, side2).put(TextureSlot.WEST, side0).put(TextureSlot.PARTICLE, side2);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CUBE.create((Block)GBlocks.COMBUSTION_TABLE.get(), texturemapping, blockModelGenerators.modelOutput))));
    }

    private static void createPinkSaltStraw(BlockModelGenerators blockModelGenerators) {
        PropertyDispatch.C2 c2 = PropertyDispatch.initial((Property)BlockStateProperties.VERTICAL_DIRECTION, PinkSaltStrawBlock.STRAW_SHAPE);
        for (PinkSaltStrawBlock.StrawShape strawShape : PinkSaltStrawBlock.StrawShape.values()) {
            c2.select((Comparable)Direction.UP, (Comparable)((Object)strawShape), (Object)GModelProvider.createPinkSaltStrawVariant(Direction.UP, strawShape, blockModelGenerators));
        }
        for (PinkSaltStrawBlock.StrawShape strawShape : PinkSaltStrawBlock.StrawShape.values()) {
            c2.select((Comparable)Direction.DOWN, (Comparable)((Object)strawShape), (Object)GModelProvider.createPinkSaltStrawVariant(Direction.DOWN, strawShape, blockModelGenerators));
        }
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.PINK_SALT_STRAW.get())).with((PropertyDispatch)c2));
    }

    private static MultiVariant createPinkSaltStrawVariant(Direction direction, PinkSaltStrawBlock.StrawShape shape, BlockModelGenerators blockModelGenerators) {
        String s = "_" + direction.getSerializedName() + "_" + shape.getSerializedName();
        TextureMapping textureMapping = TextureMapping.cross((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)GBlocks.PINK_SALT_STRAW.get()), (String)s));
        return BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.POINTED_DRIPSTONE.createWithSuffix((Block)GBlocks.PINK_SALT_STRAW.get(), s, textureMapping, blockModelGenerators.modelOutput));
    }

    private static void createShadowFrame(BlockModelGenerators blockModelGenerators) {
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.CUBE.create((Block)GBlocks.SHADOW_FRAME.get(), blockModelGenerators.modelOutput));
        MultiVariant multivariant1 = BlockModelGenerators.plainVariant((ResourceLocation)blockModelGenerators.createSuffixedVariant((Block)GBlocks.SHADOW_FRAME.get(), "_filled", ModelTemplates.CUBE_ALL, TextureMapping::cube));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.SHADOW_FRAME.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.POWERED, (MultiVariant)multivariant1, (MultiVariant)multivariant)));
    }

    private static void createLichenMoss(BlockModelGenerators blockModelGenerators) {
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.CUBE.create((Block)GBlocks.LICHEN_MOSS.get(), blockModelGenerators.modelOutput));
        MultiVariant multivariant1 = BlockModelGenerators.plainVariant((ResourceLocation)blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_MOSS.get(), "_lit", ModelTemplates.CUBE_ALL, TextureMapping::cube));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)GBlocks.LICHEN_MOSS.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)multivariant1, (MultiVariant)multivariant)));
    }

    private void createPollinatedCluster(BlockModelGenerators blockModelGenerators, @NotNull Block block) {
        ResourceLocation id = ModelTemplates.CROSS.create(block, TextureMapping.cross((Block)block), blockModelGenerators.modelOutput);
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)id);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)multivariant).with(BlockModelGenerators.ROTATIONS_COLUMN_WITH_FACING));
    }
}

