/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.blocks.blockentities.MoleBurrowBlockEntity;
import net.orcinus.galosphere.entities.ai.MoleAi;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityDataSerializers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import org.jetbrains.annotations.Nullable;

public class Mole
extends Animal {
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.defineId(Mole.class, (EntityDataSerializer)((EntityDataSerializer)GEntityDataSerializers.MOLE_STATE.get()));
    public final AnimationState twitchAnimationState = new AnimationState();
    public final AnimationState sniffAnimationState = new AnimationState();
    public final AnimationState emergeAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    @Nullable
    private BlockPos burrowPos;

    public Mole(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)State.IDLING);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public Brain<Mole> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<Mole> brainProvider() {
        return MoleAi.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return MoleAi.makeBrain((Brain<Mole>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("moleBrain");
        Brain<Mole> brain = this.getBrain();
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("moleActivityUpdate");
        MoleAi.updateActivity(this);
        profiler.pop();
        super.customServerAiStep(serverLevel);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setBurrowPos(compoundTag.read("BurrowPos", BlockPos.CODEC).orElse(null));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.storeNullable("BurrowPos", BlockPos.CODEC, (Object)this.getBurrowPos());
    }

    public boolean isPushable() {
        return !this.cannotMove() && super.isPushable();
    }

    public void handleEntityEvent(byte b) {
        if (b == 4) {
            for (int i = 0; i < 5; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d, e, f);
            }
        } else {
            super.handleEntityEvent(b);
        }
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(GItemTags.MOLE_FOOD);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)GEntityTypes.MOLE.get().create((Level)serverLevel, EntitySpawnReason.BREEDING);
    }

    public Mole transitionTo(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 1: {
                this.setState(State.TWITCHING).onTwitchingStart();
                break;
            }
            case 2: {
                this.setState(State.EMERGE).onEmergingStart();
                break;
            }
            case 3: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case 4: {
                this.setState(State.SNIFFING);
            }
        }
        return this;
    }

    public void onTwitchingStart() {
        this.playSound(SoundEvents.FOX_SNIFF, 1.0f, 1.0f);
    }

    public void onEmergingStart() {
        this.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
    }

    public void onDiggingStart() {
    }

    public static boolean isValidTargetState(Level level, BlockPos blockPos, LivingEntity livingEntity) {
        MoleBurrowBlockEntity moleBurrowBlock;
        BlockEntity blockEntity;
        if (!(livingEntity instanceof Mole)) {
            return false;
        }
        Mole mole = (Mole)livingEntity;
        return mole.getBurrowPos() == null && (blockEntity = level.getBlockEntity(blockPos)) instanceof MoleBurrowBlockEntity && (moleBurrowBlock = (MoleBurrowBlockEntity)blockEntity).isEmpty();
    }

    public static boolean isTuffDirt(Level level, BlockPos blockPos, LivingEntity livingEntity) {
        BlockState state = level.getBlockState(blockPos.above());
        return state.getFluidState().isEmpty() && state.canBeReplaced() && level.getBlockState(blockPos).is((Block)GBlocks.TUFF_DIRT.get());
    }

    protected void updateWalkAnimation(float f) {
        float g = Math.min(f * 25.0f, 1.0f);
        this.walkAnimation.update(g, 0.4f, this.isBaby() ? 0.3f : 1.0f);
    }

    public State getState() {
        return (State)((Object)this.entityData.get(DATA_STATE));
    }

    private Mole setState(State state) {
        this.entityData.set(DATA_STATE, (Object)state);
        return this;
    }

    @Nullable
    public BlockPos getBurrowPos() {
        return this.burrowPos;
    }

    public void setBurrowPos(BlockPos blockPos) {
        this.burrowPos = blockPos;
    }

    public Optional<BlockPos> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(i -> LandRandomPos.getPos((PathfinderMob)this, (int)4, (int)2)).filter(Objects::nonNull).map(BlockPos::containing).filter(blockPos -> this.level().getWorldBorder().isWithinBounds(blockPos)).map(BlockPos::below).filter(this::canDig).findFirst();
    }

    public void tick() {
        super.tick();
        if (this.getState() == State.DIGGING) {
            long animationTime = this.diggingAnimationState.getTimeInMillis((float)this.tickCount);
            BlockPos blockPos = this.blockPosition();
            BlockState blockState = this.level().getBlockState(blockPos.below());
            if (animationTime > 1000L && blockState.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos).add(0.0, (double)-0.65f, 0.0);
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 2 == 0) {
                    float pitch = this.isBaby() ? 0.7f : 0.5f;
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), blockState.getSoundType().getHitSound(), this.getSoundSource(), 0.5f, pitch, false);
                }
            }
        }
    }

    public boolean isTempted() {
        return this.brain.getMemory(MemoryModuleType.IS_TEMPTED).orElse(false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (DATA_STATE.equals(entityDataAccessor)) {
            State state = this.getState();
            this.resetAnimations();
            switch (state.ordinal()) {
                case 1: {
                    this.twitchAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 2: {
                    this.emergeAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 3: {
                    this.diggingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 4: {
                    this.sniffAnimationState.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(entityDataAccessor);
    }

    private void resetAnimations() {
        this.twitchAnimationState.stop();
        this.diggingAnimationState.stop();
        this.emergeAnimationState.stop();
        this.sniffAnimationState.stop();
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.isBaby() && !this.isPanicking() && !this.isInWater() && !this.isInLove() && !this.isPassenger() && !this.isLeashed();
    }

    public boolean canDig() {
        BlockState belowState = this.level().getBlockState(this.blockPosition().below());
        return belowState.is(GBlockTags.MOLE_DIGGABLE_BLOCK) && !this.isPanicking() && !this.isTempted() && !this.isBaby() && !this.isLeashed() && !this.isInWater() && this.onGround() && !this.isPassenger() && this.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT).isEmpty();
    }

    private boolean canDig(BlockPos blockPos) {
        return this.level().getBlockState(blockPos).is(GBlockTags.MOLE_DIGGABLE_BLOCK) && Optional.ofNullable(this.getNavigation().createPath(blockPos, 1)).map(Path::canReach).orElse(false) != false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (mobSpawnType == EntitySpawnReason.TRIGGERED) {
            this.setBurrowPos(this.blockPosition().below());
            this.transitionTo(State.EMERGE);
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.IS_EMERGING, (Object)Unit.INSTANCE, 40L);
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, (Object)Unit.INSTANCE, 200L);
        }
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    public void travel(Vec3 vec3) {
        if (this.cannotMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            vec3 = vec3.multiply(0.0, 1.0, 0.0);
        }
        super.travel(vec3);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return MoleAi.getSoundForActivity(this);
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.is(GItemTags.MOLE_FAVORITES)) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.CAMEL_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            this.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.MOLE_HOMING.get(), (Object)Unit.INSTANCE, 6000L);
            itemStack.consume(1, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, interactionHand);
    }

    private boolean cannotMove() {
        State state = this.getState();
        return state == State.EMERGE || state == State.DIGGING;
    }

    public static enum State {
        IDLING(0),
        TWITCHING(1),
        EMERGE(2),
        DIGGING(3),
        SNIFFING(4);

        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int j) {
            this.id = j;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(State::id, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

