/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class WeaponRack
extends HangingEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(WeaponRack.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.defineId(WeaponRack.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float dropChance = 1.0f;
    private boolean fixed = false;

    public WeaponRack(EntityType<? extends WeaponRack> entityType, Level level) {
        super(entityType, level);
        this.setInvisible(false);
    }

    public WeaponRack(Level level, BlockPos blockPos, Direction direction) {
        this(GEntityTypes.WEAPON_RACK.get(), level, blockPos, direction);
    }

    public WeaponRack(EntityType<? extends WeaponRack> entityType, Level level, BlockPos blockPos, Direction direction) {
        super(entityType, level, blockPos);
        this.setDirection(direction);
        this.setInvisible(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_ROTATION, (Object)0);
    }

    protected void setDirection(Direction direction) {
        Validate.notNull((Object)direction);
        this.direction = direction;
        if (direction.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * direction.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.recreateFromPacket(clientboundAddEntityPacket);
        this.setDirection(Direction.from3DDataValue((int)clientboundAddEntityPacket.getData()));
    }

    public float getVisualRotationYInDegrees() {
        Direction direction = this.getDirection();
        int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + this.getRotation() * 45 + i));
    }

    protected AABB calculateBoundingBox(BlockPos blockPos, Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos).relative(direction, -0.46875);
        Direction.Axis axis = direction.getAxis();
        double d = axis == Direction.Axis.X ? 0.0625 : 0.75;
        double e = axis == Direction.Axis.Y ? 0.0625 : 0.75;
        double g = axis == Direction.Axis.Z ? 0.0625 : 0.75;
        return AABB.ofSize((Vec3)vec3, (double)d, (double)e, (double)g);
    }

    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        BlockState blockState = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        return blockState.isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode((BlockState)blockState) ? this.level().getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty() : false;
    }

    public void move(MoverType moverType, Vec3 vec3) {
        if (!this.fixed) {
            super.move(moverType, vec3);
        }
    }

    public void push(double d, double e, double f) {
        if (!this.fixed) {
            super.push(d, e, f);
        }
    }

    public void kill(ServerLevel serverLevel) {
        super.kill(serverLevel);
    }

    public boolean hurtClient(DamageSource damageSource) {
        return (!this.fixed || WeaponRack.canHurtWhenFixed(damageSource)) && !this.isInvulnerableToBase(damageSource);
    }

    private static boolean canHurtWhenFixed(DamageSource damageSource) {
        return damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || damageSource.isCreativePlayer();
    }

    private boolean shouldDamageDropItem(DamageSource damageSource) {
        return !damageSource.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float f) {
        if (!this.fixed) {
            if (this.isInvulnerableToBase(damageSource)) {
                return false;
            }
            if (this.shouldDamageDropItem(damageSource)) {
                this.dropItem(serverLevel, damageSource.getEntity(), false);
                this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, damageSource.getEntity());
                this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
                return true;
            }
            return super.hurtServer(serverLevel, damageSource, f);
        }
        return WeaponRack.canHurtWhenFixed(damageSource) && super.hurtServer(serverLevel, damageSource, f);
    }

    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        double e = 16.0;
        return d < (e *= 64.0 * WeaponRack.getViewScale()) * e;
    }

    public void dropItem(ServerLevel serverLevel, @Nullable Entity entity) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(serverLevel, entity, true);
        this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, entity);
    }

    private void dropItem(ServerLevel serverLevel, @Nullable Entity entity, boolean bl) {
        if (!this.fixed) {
            ItemStack itemStack = this.getItem();
            this.setItem(ItemStack.EMPTY);
            if (!serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                return;
            }
            if (bl) {
                this.spawnAtLocation(serverLevel, this.getFrameItemStack());
            }
            if (!itemStack.isEmpty()) {
                itemStack = itemStack.copy();
                if (this.random.nextFloat() < this.dropChance) {
                    this.spawnAtLocation(serverLevel, itemStack);
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        ItemStack itemStack = this.getItem();
        if (!itemStack.isEmpty()) {
            RegistryOps registryOps = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            compoundTag.store("Item", ItemStack.CODEC, (DynamicOps)registryOps, (Object)itemStack);
        }
        compoundTag.putByte("ItemRotation", (byte)this.getRotation());
        compoundTag.putFloat("ItemDropChance", this.dropChance);
        compoundTag.store("Facing", Direction.LEGACY_ID_CODEC, (Object)this.direction);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        RegistryOps registryOps = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ItemStack itemStack = compoundTag.read("Item", ItemStack.CODEC, (DynamicOps)registryOps).orElse(ItemStack.EMPTY);
        this.setItem(itemStack, false);
        this.setRotation(compoundTag.getByteOr("ItemRotation", (byte)0), false);
        this.dropChance = compoundTag.getFloatOr("ItemDropChance", 1.0f);
        this.setDirection(compoundTag.read("Facing", Direction.LEGACY_ID_CODEC).orElse(Direction.DOWN));
    }

    public void setItem(ItemStack itemStack) {
        this.setItem(itemStack, true);
    }

    public void setItem(ItemStack itemStack, boolean bl) {
        if (!itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(1);
        }
        this.onItemChanged(itemStack);
        this.getEntityData().set(DATA_ITEM, (Object)itemStack);
        if (!itemStack.isEmpty()) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (bl) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (entityDataAccessor.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(ItemStack itemStack) {
        if (!itemStack.isEmpty() && itemStack.getEntityRepresentation() instanceof WeaponRack) {
            itemStack.setEntityRepresentation((Entity)this);
        }
        this.recalculateBoundingBox();
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        boolean hasItem;
        ItemStack itemStack = player.getItemInHand(interactionHand);
        boolean holdingItem = !this.getItem().isEmpty();
        boolean bl = hasItem = !itemStack.isEmpty() && itemStack.is(GItemTags.WEAPON_RACKS_CAN_HOLD);
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (!player.level().isClientSide) {
            if (!holdingItem) {
                if (hasItem && !this.isRemoved()) {
                    this.setItem(itemStack);
                    this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
                    itemStack.consume(1, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
            this.setRotation(this.getRotation() + 1);
            this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        return !holdingItem && !hasItem ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    @Nullable
    public ItemStack getPickResult() {
        ItemStack itemStack = this.getItem();
        return itemStack.isEmpty() ? this.getFrameItemStack() : itemStack.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)GItems.WEAPON_RACK.get());
    }

    public int getRotation() {
        return (Integer)this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int i) {
        this.setRotation(i, true);
    }

    private void setRotation(int i, boolean bl) {
        this.getEntityData().set(DATA_ROTATION, (Object)(i % 8));
        if (bl) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEvent getBreakSound() {
        return GSoundEvents.PALLADIUM.getBreakSound();
    }

    public SoundEvent getPlaceSound() {
        return GSoundEvents.PALLADIUM.getPlaceSound();
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }
}

