/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class Rummaging
extends Behavior<Mole> {
    public Rummaging() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.SNIFF_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_PRESENT), 40);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mole livingEntity) {
        return livingEntity.canDig();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Mole livingEntity, long l) {
        return livingEntity.canDig() && !livingEntity.isInLove();
    }

    protected void start(ServerLevel serverLevel, Mole livingEntity, long l) {
        livingEntity.transitionTo(Mole.State.DIGGING);
        livingEntity.getBrain().setMemory(GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)Unit.INSTANCE);
    }

    protected void stop(ServerLevel serverLevel, Mole livingEntity, long l) {
        Brain<Mole> brain = livingEntity.getBrain();
        if (this.timedOut(l)) {
            brain.setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, (Object)Unit.INSTANCE, 100L);
        } else {
            brain.eraseMemory(GMemoryModuleTypes.MOLE_DIGGING.get());
            brain.eraseMemory(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get());
            livingEntity.transitionTo(Mole.State.IDLING);
        }
    }
}

