/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.spectre;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class LaySpecterpillar
extends Behavior<Spectre> {
    public LaySpecterpillar() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.IS_PREGNANT, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Spectre livingEntity) {
        return !livingEntity.getBlockStateOn().is((Block)GBlocks.LICHEN_MOSS.get());
    }

    protected boolean canStillUse(ServerLevel serverLevel, Spectre livingEntity, long l) {
        return this.checkExtraStartConditions(serverLevel, livingEntity);
    }

    protected void start(ServerLevel serverLevel, Spectre livingEntity, long l) {
        this.getNearstLichenMoss(livingEntity).filter(blockPos -> serverLevel.getBlockState(blockPos.below()).is((Block)GBlocks.LICHEN_MOSS.get())).ifPresent(blockPos -> {
            boolean flag;
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)livingEntity, (BlockPos)blockPos, (float)1.0f, (int)0);
            boolean bl = flag = blockPos.distManhattan((Vec3i)livingEntity.blockPosition()) <= 0;
            if (flag) {
                this.stop(serverLevel, livingEntity, l);
            }
        });
    }

    protected void stop(ServerLevel serverLevel, Spectre livingEntity, long l) {
        if (!livingEntity.getBlockStateOn().is((Block)GBlocks.LICHEN_MOSS.get())) {
            livingEntity.getBrain().eraseMemory(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
        } else {
            Vec3 pos = livingEntity.position();
            int count = UniformInt.of((int)1, (int)4).sample(livingEntity.getRandom());
            for (int i = 0; i < count; ++i) {
                Specterpillar specterpillar = (Specterpillar)GEntityTypes.SPECTERPILLAR.get().create((Level)serverLevel, EntitySpawnReason.BREEDING);
                specterpillar.snapTo(pos.x(), pos.y() + 0.2, pos.z(), 0.0f, 0.0f);
                specterpillar.setPersistenceRequired();
                serverLevel.addFreshEntity((Entity)specterpillar);
            }
            livingEntity.playSound(SoundEvents.FROG_LAY_SPAWN, 1.0f, 1.0f);
            livingEntity.getBrain().eraseMemory(MemoryModuleType.IS_PREGNANT);
            livingEntity.getBrain().eraseMemory(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
        }
    }

    private Optional<BlockPos> getNearstLichenMoss(Spectre livingEntity) {
        return livingEntity.getBrain().getMemory(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
    }
}

